/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.internal.ObjectUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, CharSequence charSequence, List<Object> list) {
        if (charSequence.length() == 0) {
            return;
        }
        list.add(ByteBufUtil.encodeString((ByteBufAllocator)channelHandlerContext.alloc(), (CharBuffer)CharBuffer.wrap(charSequence), (Charset)this.charset));
    }
}

