/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.NameResolver;
import io.netty.resolver.SimpleNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.List;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    public CompositeNameResolver(EventExecutor eventExecutor, NameResolver<T> ... nameResolverArray) {
        super(eventExecutor);
        ObjectUtil.checkNotNull(nameResolverArray, (String)"resolvers");
        for (int i = 0; i < nameResolverArray.length; ++i) {
            ObjectUtil.checkNotNull(nameResolverArray[i], (String)("resolvers[" + i + ']'));
        }
        if (nameResolverArray.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(nameResolverArray) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])nameResolverArray.clone();
    }

    @Override
    protected final void doResolve(String string, Promise<T> promise) {
        this.doResolveRec(string, promise, 0, null);
    }

    private void doResolveRec(final String string, final Promise<T> promise, final int n, Throwable object) {
        if (n >= this.resolvers.length) {
            promise.setFailure((Throwable)object);
            return;
        }
        object = this.resolvers[n];
        object.resolve(string).addListener((GenericFutureListener)new FutureListener<T>(){

            public void operationComplete(Future<T> future) {
                if (future.isSuccess()) {
                    promise.setSuccess(future.getNow());
                    return;
                }
                CompositeNameResolver.this.doResolveRec(string, promise, n + 1, future.cause());
            }
        });
    }

    @Override
    protected final void doResolveAll(String string, Promise<List<T>> promise) {
        this.doResolveAllRec(string, promise, 0, null);
    }

    private void doResolveAllRec(final String string, final Promise<List<T>> promise, final int n, Throwable object) {
        if (n >= this.resolvers.length) {
            promise.setFailure((Throwable)object);
            return;
        }
        object = this.resolvers[n];
        object.resolveAll(string).addListener((GenericFutureListener)new FutureListener<List<T>>(){

            public void operationComplete(Future<List<T>> future) {
                if (future.isSuccess()) {
                    promise.setSuccess(future.getNow());
                    return;
                }
                CompositeNameResolver.this.doResolveAllRec(string, promise, n + 1, future.cause());
            }
        });
    }
}

