/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;

final class NetUtilInitializations {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NetUtilInitializations.class);

    private NetUtilInitializations() {
    }

    static Inet4Address createLocalhost4() {
        Object object = new byte[]{127, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException(exception);
        }
        return inet4Address;
    }

    static Inet6Address createLocalhost6() {
        Object object = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet6Address inet6Address = null;
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress("localhost", object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException(exception);
        }
        return inet6Address;
    }

    static Collection<NetworkInterface> networkInterfaces() {
        ArrayList<NetworkInterface> arrayList;
        block5: {
            arrayList = new ArrayList<NetworkInterface>();
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        arrayList.add(enumeration.nextElement());
                    }
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to retrieve the list of available network interfaces", socketException);
            }
            catch (NullPointerException nullPointerException) {
                if (PlatformDependent.isAndroid()) break block5;
                throw nullPointerException;
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    static NetworkIfaceAndInetAddress determineLoopback(Collection<NetworkInterface> object, Inet4Address inet4Address, Inet6Address inet6Address) {
        Enumeration<InetAddress> enumeration;
        Object object2;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (NetworkInterface)object.next();
            if (!SocketUtils.addressesFromNetworkInterface((NetworkInterface)object2).hasMoreElements()) continue;
            arrayList.add((NetworkInterface)object2);
        }
        object = null;
        object2 = null;
        block6: for (NetworkInterface networkInterface : arrayList) {
            enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object = networkInterface;
                object2 = inetAddress;
                break block6;
            }
        }
        if (object == null) {
            try {
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.isLoopback() || !(enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface)).hasMoreElements()) continue;
                    object = networkInterface;
                    object2 = enumeration.nextElement();
                    break;
                }
                if (object == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object).getName(), ((NetworkInterface)object).getDisplayName(), ((InetAddress)object2).getHostAddress());
        } else if (object2 == null) {
            try {
                if (NetworkInterface.getByInetAddress(inet6Address) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)inet6Address);
                    object2 = inet6Address;
                }
                if (object2 == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object2 = inet4Address;
                }
            }
            catch (Exception exception) {
                if (object2 == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object2 = inet4Address;
                }
            }
            catch (Throwable throwable) {
                if (object2 == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                }
                throw throwable;
            }
        }
        return new NetworkIfaceAndInetAddress((NetworkInterface)object, (InetAddress)object2);
    }

    static final class NetworkIfaceAndInetAddress {
        private final NetworkInterface iface;
        private final InetAddress address;

        NetworkIfaceAndInetAddress(NetworkInterface networkInterface, InetAddress inetAddress) {
            this.iface = networkInterface;
            this.address = inetAddress;
        }

        public final NetworkInterface iface() {
            return this.iface;
        }

        public final InetAddress address() {
            return this.address;
        }
    }
}

