/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class NonStickyEventExecutorGroup
implements EventExecutorGroup {
    private final EventExecutorGroup group;
    private final int maxTaskExecutePerRun;

    public NonStickyEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        this(eventExecutorGroup, 1024);
    }

    public NonStickyEventExecutorGroup(EventExecutorGroup eventExecutorGroup, int n) {
        this.group = NonStickyEventExecutorGroup.verify(eventExecutorGroup);
        this.maxTaskExecutePerRun = ObjectUtil.checkPositive(n, "maxTaskExecutePerRun");
    }

    private static EventExecutorGroup verify(EventExecutorGroup eventExecutorGroup) {
        for (EventExecutor eventExecutor : ObjectUtil.checkNotNull(eventExecutorGroup, "group")) {
            if (!(eventExecutor instanceof OrderedEventExecutor)) continue;
            throw new IllegalArgumentException("EventExecutorGroup " + eventExecutorGroup + " contains OrderedEventExecutors: " + eventExecutor);
        }
        return eventExecutorGroup;
    }

    private NonStickyOrderedEventExecutor newExecutor(EventExecutor eventExecutor) {
        return new NonStickyOrderedEventExecutor(eventExecutor, this.maxTaskExecutePerRun);
    }

    @Override
    public final boolean isShuttingDown() {
        return this.group.isShuttingDown();
    }

    @Override
    public final Future<?> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    @Override
    public final Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        return this.group.shutdownGracefully(l, l2, timeUnit);
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.group.terminationFuture();
    }

    @Override
    public final void shutdown() {
        this.group.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.group.shutdownNow();
    }

    @Override
    public final EventExecutor next() {
        NonStickyEventExecutorGroup nonStickyEventExecutorGroup = this;
        return nonStickyEventExecutorGroup.newExecutor(nonStickyEventExecutorGroup.group.next());
    }

    @Override
    public final Iterator<EventExecutor> iterator() {
        final Iterator<EventExecutor> iterator = this.group.iterator();
        return new Iterator<EventExecutor>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public EventExecutor next() {
                return NonStickyEventExecutorGroup.this.newExecutor((EventExecutor)iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public final Future<?> submit(Runnable runnable) {
        return this.group.submit(runnable);
    }

    @Override
    public final <T> Future<T> submit(Runnable runnable, T t) {
        return this.group.submit(runnable, t);
    }

    @Override
    public final <T> Future<T> submit(Callable<T> callable) {
        return this.group.submit(callable);
    }

    @Override
    public final ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.group.schedule(runnable, l, timeUnit);
    }

    @Override
    public final <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        return this.group.schedule(callable, l, timeUnit);
    }

    @Override
    public final ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.group.scheduleAtFixedRate(runnable, l, l2, timeUnit);
    }

    @Override
    public final ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.group.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
    }

    @Override
    public final boolean isShutdown() {
        return this.group.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.group.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long l, TimeUnit timeUnit) {
        return this.group.awaitTermination(l, timeUnit);
    }

    @Override
    public final <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        return this.group.invokeAll(collection);
    }

    @Override
    public final <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) {
        return this.group.invokeAll(collection, l, timeUnit);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> collection) {
        return this.group.invokeAny(collection);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) {
        return this.group.invokeAny(collection, l, timeUnit);
    }

    @Override
    public final void execute(Runnable runnable) {
        this.group.execute(runnable);
    }

    private static final class NonStickyOrderedEventExecutor
    extends AbstractEventExecutor
    implements OrderedEventExecutor,
    Runnable {
        private final EventExecutor executor;
        private final Queue<Runnable> tasks = PlatformDependent.newMpscQueue();
        private static final int NONE = 0;
        private static final int SUBMITTED = 1;
        private static final int RUNNING = 2;
        private final AtomicInteger state = new AtomicInteger();
        private final int maxTaskExecutePerRun;
        private final AtomicReference<Thread> executingThread = new AtomicReference();

        NonStickyOrderedEventExecutor(EventExecutor eventExecutor, int n) {
            super(eventExecutor);
            this.executor = eventExecutor;
            this.maxTaskExecutePerRun = n;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public final void run() {
            if (!this.state.compareAndSet(1, 2)) {
                return;
            }
            var1_1 = Thread.currentThread();
            this.executingThread.set(var1_1);
            while (true) lbl-1000:
            // 3 sources

            {
                block12: {
                    for (var2_2 = 0; var2_2 < this.maxTaskExecutePerRun && (var3_3 = this.tasks.poll()) != null; ++var2_2) {
                        NonStickyOrderedEventExecutor.safeExecute(var3_3);
                    }
                    if (var2_2 != this.maxTaskExecutePerRun) break block12;
                    try {
                        this.state.set(1);
                        this.executingThread.compareAndSet(var1_1, null);
                        this.executor.execute(this);
                        return;
                    }
                    catch (Throwable v0) {
                        this.state.set(2);
                    }
                    ** GOTO lbl-1000
                }
                this.state.set(0);
                if (this.tasks.isEmpty() || !this.state.compareAndSet(0, 2)) break;
            }
            this.executingThread.compareAndSet(var1_1, null);
            return;
            catch (Throwable var3_4) {
                if (var2_2 == this.maxTaskExecutePerRun) {
                    try {
                        this.state.set(1);
                        this.executingThread.compareAndSet(var1_1, null);
                        this.executor.execute(this);
                        return;
                    }
                    catch (Throwable v1) {
                        this.state.set(2);
                    }
                } else {
                    this.state.set(0);
                    if (this.tasks.isEmpty() || !this.state.compareAndSet(0, 2)) {
                        this.executingThread.compareAndSet(var1_1, null);
                        return;
                    }
                }
                throw var3_4;
            }
        }

        @Override
        public final boolean inEventLoop(Thread thread) {
            return this.executingThread.get() == thread;
        }

        @Override
        public final boolean isShuttingDown() {
            return this.executor.isShutdown();
        }

        @Override
        public final Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
            return this.executor.shutdownGracefully(l, l2, timeUnit);
        }

        @Override
        public final Future<?> terminationFuture() {
            return this.executor.terminationFuture();
        }

        @Override
        public final void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public final boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public final boolean awaitTermination(long l, TimeUnit timeUnit) {
            return this.executor.awaitTermination(l, timeUnit);
        }

        @Override
        public final void execute(Runnable runnable) {
            if (!this.tasks.offer(runnable)) {
                throw new RejectedExecutionException();
            }
            if (this.state.compareAndSet(0, 1)) {
                this.executor.execute(this);
            }
        }
    }
}

