/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;

public final class AppendableCharSequence
implements Appendable,
CharSequence {
    private char[] chars;
    private int pos;

    public AppendableCharSequence(int n) {
        this.chars = new char[ObjectUtil.checkPositive(n, "length")];
    }

    private AppendableCharSequence(char[] cArray) {
        this.chars = ObjectUtil.checkNonEmpty(cArray, "chars");
        this.pos = cArray.length;
    }

    public final void setLength(int n) {
        if (n < 0 || n > this.pos) {
            throw new IllegalArgumentException("length: " + n + " (length: >= 0, <= " + this.pos + ')');
        }
        this.pos = n;
    }

    @Override
    public final int length() {
        return this.pos;
    }

    @Override
    public final char charAt(int n) {
        if (n > this.pos) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[n];
    }

    public final char charAtUnsafe(int n) {
        return this.chars[n];
    }

    @Override
    public final AppendableCharSequence subSequence(int n, int n2) {
        if (n == n2) {
            return new AppendableCharSequence(Math.min(16, this.chars.length));
        }
        return new AppendableCharSequence(Arrays.copyOfRange(this.chars, n, n2));
    }

    @Override
    public final AppendableCharSequence append(char c) {
        if (this.pos == this.chars.length) {
            char[] cArray = this.chars;
            this.chars = new char[cArray.length << 1];
            System.arraycopy(cArray, 0, this.chars, 0, cArray.length);
        }
        this.chars[this.pos++] = c;
        return this;
    }

    @Override
    public final AppendableCharSequence append(CharSequence charSequence) {
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public final AppendableCharSequence append(CharSequence object, int n, int n2) {
        if (object.length() < n2) {
            throw new IndexOutOfBoundsException("expected: csq.length() >= (" + n2 + "),but actual is (" + object.length() + ")");
        }
        int n3 = n2 - n;
        if (n3 > this.chars.length - this.pos) {
            this.chars = AppendableCharSequence.expand(this.chars, this.pos + n3, this.pos);
        }
        if (object instanceof AppendableCharSequence) {
            AppendableCharSequence appendableCharSequence = (AppendableCharSequence)object;
            object = appendableCharSequence.chars;
            System.arraycopy(appendableCharSequence.chars, n, this.chars, this.pos, n3);
            this.pos += n3;
            return this;
        }
        for (int i = n; i < n2; ++i) {
            this.chars[this.pos++] = object.charAt(i);
        }
        return this;
    }

    public final void reset() {
        this.pos = 0;
    }

    @Override
    public final String toString() {
        return new String(this.chars, 0, this.pos);
    }

    public final String substring(int n, int n2) {
        if (n > this.pos || (n2 -= n) > this.pos) {
            throw new IndexOutOfBoundsException("expected: start and length <= (" + this.pos + ")");
        }
        return new String(this.chars, n, n2);
    }

    public final String subStringUnsafe(int n, int n2) {
        return new String(this.chars, n, n2 - n);
    }

    private static char[] expand(char[] cArray, int n, int n2) {
        int n3 = cArray.length;
        do {
            if ((n3 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n > n3);
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }
}

