/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadLocalRandom
extends Random {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ThreadLocalRandom.class);
    private static final AtomicLong seedUniquifier = new AtomicLong();
    private static volatile long initialSeedUniquifier = SystemPropertyUtil.getLong("io.netty.initialSeedUniquifier", 0L);
    private static final Thread seedGeneratorThread;
    private static final BlockingQueue<Long> seedQueue;
    private static final long seedGeneratorStartTime;
    private static volatile long seedGeneratorEndTime;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long rnd;
    boolean initialized = true;
    private long pad0;
    private long pad1;
    private long pad2;
    private long pad3;
    private long pad4;
    private long pad5;
    private long pad6;
    private long pad7;
    private static final long serialVersionUID = -5851777807851030925L;

    public static void setInitialSeedUniquifier(long l) {
        initialSeedUniquifier = l;
    }

    public static long getInitialSeedUniquifier() {
        long l = initialSeedUniquifier;
        if (l != 0L) {
            return l;
        }
        Class<ThreadLocalRandom> clazz = ThreadLocalRandom.class;
        synchronized (ThreadLocalRandom.class) {
            boolean bl;
            block10: {
                long l2;
                l = initialSeedUniquifier;
                if (l != 0L) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return l;
                }
                long l3 = seedGeneratorStartTime + TimeUnit.SECONDS.toNanos(3L);
                bl = false;
                do {
                    l2 = l3 - System.nanoTime();
                    try {
                        Long l4 = l2 <= 0L ? (Long)seedQueue.poll() : seedQueue.poll(l2, TimeUnit.NANOSECONDS);
                        if (l4 == null) continue;
                        l = l4;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        logger.warn("Failed to generate a seed from SecureRandom due to an InterruptedException.");
                    }
                    break block10;
                } while (l2 > 0L);
                seedGeneratorThread.interrupt();
                logger.warn("Failed to generate a seed from SecureRandom within {} seconds. Not enough entropy?", (Object)3L);
            }
            l ^= 0x3255ECDC33BAE119L;
            initialSeedUniquifier = l ^= Long.reverse(System.nanoTime());
            if (bl) {
                Thread.currentThread().interrupt();
                seedGeneratorThread.interrupt();
            }
            if (seedGeneratorEndTime == 0L) {
                seedGeneratorEndTime = System.nanoTime();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return l;
        }
    }

    private static long newSeed() {
        long l;
        long l2;
        long l3;
        while (!seedUniquifier.compareAndSet(l3, l2 = (l = (l3 = seedUniquifier.get()) != 0L ? l3 : ThreadLocalRandom.getInitialSeedUniquifier()) * 181783497276652981L)) {
        }
        if (l3 == 0L && logger.isDebugEnabled()) {
            if (seedGeneratorEndTime != 0L) {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x (took %d ms)", l, TimeUnit.NANOSECONDS.toMillis(seedGeneratorEndTime - seedGeneratorStartTime)));
            } else {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x", l));
            }
        }
        return l2 ^ System.nanoTime();
    }

    private static long mix64(long l) {
        long l2 = l;
        l = (l2 ^ l2 >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        return l ^ l >>> 33;
    }

    ThreadLocalRandom() {
        super(ThreadLocalRandom.newSeed());
    }

    public static ThreadLocalRandom current() {
        return InternalThreadLocalMap.get().random();
    }

    @Override
    public final void setSeed(long l) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        this.rnd = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    protected final int next(int n) {
        this.rnd = this.rnd * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.rnd >>> 48 - n);
    }

    @Override
    public final int nextInt(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException();
        }
        return this.nextInt(n2 - n) + n;
    }

    @Override
    public final long nextLong(long l) {
        ObjectUtil.checkPositive(l, "n");
        long l2 = 0L;
        while (l >= Integer.MAX_VALUE) {
            long l3;
            int n = this.next(2);
            long l4 = l >>> 1;
            long l5 = l3 = (n & 2) == 0 ? l4 : l - l4;
            if ((n & 1) == 0) {
                l2 += l - l3;
            }
            l = l3;
        }
        return l2 + (long)this.nextInt((int)l);
    }

    @Override
    public final long nextLong(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException();
        }
        return this.nextLong(l2 - l) + l;
    }

    @Override
    public final double nextDouble(double d) {
        ObjectUtil.checkPositive(d, "n");
        return this.nextDouble() * d;
    }

    @Override
    public final double nextDouble(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException();
        }
        return this.nextDouble() * (d2 - d) + d;
    }

    static {
        if (initialSeedUniquifier == 0L) {
            boolean bl = SystemPropertyUtil.getBoolean("java.util.secureRandomSeed", false);
            if (bl) {
                seedQueue = new LinkedBlockingQueue<Long>();
                seedGeneratorStartTime = System.nanoTime();
                seedGeneratorThread = new Thread("initialSeedUniquifierGenerator"){

                    @Override
                    public final void run() {
                        Object object = new SecureRandom();
                        object = ((SecureRandom)object).generateSeed(8);
                        seedGeneratorEndTime = System.nanoTime();
                        long l = ((long)object[0] & 0xFFL) << 56 | ((long)object[1] & 0xFFL) << 48 | ((long)object[2] & 0xFFL) << 40 | ((long)object[3] & 0xFFL) << 32 | ((long)object[4] & 0xFFL) << 24 | ((long)object[5] & 0xFFL) << 16 | ((long)object[6] & 0xFFL) << 8 | (long)object[7] & 0xFFL;
                        seedQueue.add(l);
                    }
                };
                seedGeneratorThread.setDaemon(true);
                seedGeneratorThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public final void uncaughtException(Thread thread, Throwable throwable) {
                        logger.debug("An exception has been raised by {}", (Object)thread.getName(), (Object)throwable);
                    }
                });
                seedGeneratorThread.start();
            } else {
                initialSeedUniquifier = ThreadLocalRandom.mix64(System.currentTimeMillis()) ^ ThreadLocalRandom.mix64(System.nanoTime());
                seedGeneratorThread = null;
                seedQueue = null;
                seedGeneratorStartTime = 0L;
            }
        } else {
            seedGeneratorThread = null;
            seedQueue = null;
            seedGeneratorStartTime = 0L;
        }
    }
}

