/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeParameterMatcher {
    private static final TypeParameterMatcher NOOP = new TypeParameterMatcher(){

        @Override
        public final boolean match(Object object) {
            return true;
        }
    };

    public static TypeParameterMatcher get(Class<?> clazz) {
        Map<Class<?>, TypeParameterMatcher> map = InternalThreadLocalMap.get().typeParameterMatcherGetCache();
        TypeParameterMatcher typeParameterMatcher = map.get(clazz);
        if (typeParameterMatcher == null) {
            typeParameterMatcher = clazz == Object.class ? NOOP : new ReflectiveMatcher(clazz);
            map.put(clazz, typeParameterMatcher);
        }
        return typeParameterMatcher;
    }

    public static TypeParameterMatcher find(Object object, Class<?> clazz, String string) {
        Class<?> clazz2;
        Map<Class<?>, Map<String, TypeParameterMatcher>> map = InternalThreadLocalMap.get().typeParameterMatcherFindCache();
        Map<String, TypeParameterMatcher> map2 = map.get(clazz2 = object.getClass());
        if (map2 == null) {
            map2 = new HashMap<String, TypeParameterMatcher>();
            map.put(clazz2, map2);
        }
        if ((map = map2.get(string)) == null) {
            map = TypeParameterMatcher.get(TypeParameterMatcher.find0(object, clazz, string));
            map2.put(string, (TypeParameterMatcher)((Object)map));
        }
        return map;
    }

    private static Class<?> find0(Object clazz, Class<?> object, String string) {
        Class<?> clazz2 = clazz = clazz.getClass();
        while (true) {
            if (clazz2.getSuperclass() == object) {
                int n = -1;
                TypeVariable<Class<?>>[] typeVariableArray = clazz2.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeVariableArray.length; ++i) {
                    if (!string.equals(typeVariableArray[i].getName())) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    throw new IllegalStateException("unknown type parameter '" + string + "': " + object);
                }
                Type type = clazz2.getGenericSuperclass();
                if (!(type instanceof ParameterizedType)) {
                    return Object.class;
                }
                object = ((ParameterizedType)type).getActualTypeArguments();
                if ((object = object[n]) instanceof ParameterizedType) {
                    object = ((ParameterizedType)object).getRawType();
                }
                if (object instanceof Class) {
                    return (Class)object;
                }
                if (object instanceof GenericArrayType) {
                    Type type2 = ((GenericArrayType)object).getGenericComponentType();
                    if (type2 instanceof ParameterizedType) {
                        type2 = ((ParameterizedType)type2).getRawType();
                    }
                    if (type2 instanceof Class) {
                        return Array.newInstance((Class)type2, 0).getClass();
                    }
                }
                if (object instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)object;
                    if (!(typeVariable.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    clazz2 = clazz;
                    object = (Class)typeVariable.getGenericDeclaration();
                    string = typeVariable.getName();
                    if (((Class)object).isAssignableFrom(clazz)) continue;
                    return Object.class;
                }
                return TypeParameterMatcher.fail(clazz, string);
            }
            if ((clazz2 = clazz2.getSuperclass()) == null) break;
        }
        return TypeParameterMatcher.fail(clazz, string);
    }

    private static Class<?> fail(Class<?> clazz, String string) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + string + "': " + clazz);
    }

    public abstract boolean match(Object var1);

    TypeParameterMatcher() {
    }

    private static final class ReflectiveMatcher
    extends TypeParameterMatcher {
        private final Class<?> type;

        ReflectiveMatcher(Class<?> clazz) {
            this.type = clazz;
        }

        @Override
        public final boolean match(Object object) {
            return this.type.isInstance(object);
        }
    }
}

