/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.util;

import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;

public final class UnsafeLongArrayAccess {
    public static final long LONG_ARRAY_BASE;
    public static final int LONG_ELEMENT_SHIFT;

    public static void spLongElement(long[] lArray, long l, long l2) {
        UnsafeAccess.UNSAFE.putLong(lArray, l, l2);
    }

    public static void soLongElement(long[] lArray, long l, long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(lArray, l, l2);
    }

    public static long lpLongElement(long[] lArray, long l) {
        return UnsafeAccess.UNSAFE.getLong(lArray, l);
    }

    public static long lvLongElement(long[] lArray, long l) {
        return UnsafeAccess.UNSAFE.getLongVolatile(lArray, l);
    }

    public static long calcLongElementOffset(long l) {
        return LONG_ARRAY_BASE + (l << LONG_ELEMENT_SHIFT);
    }

    public static long calcCircularLongElementOffset(long l, long l2) {
        return LONG_ARRAY_BASE + ((l & l2) << LONG_ELEMENT_SHIFT);
    }

    public static long[] allocateLongArray(int n) {
        return new long[n];
    }

    static {
        int n = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        if (8 != n) {
            throw new IllegalStateException("Unknown pointer size: " + n);
        }
        LONG_ELEMENT_SHIFT = 3;
        LONG_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
    }
}

