/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    public static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int MAX_CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress;
    private final ByteBuf memory;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this(Unpooled.wrappedBuffer((ByteBuffer)Buffer.allocateDirectWithNativeOrder(MAX_CAPACITY)).setIndex(0, 0));
    }

    public IovArray(ByteBuf byteBuf) {
        assert (byteBuf.writerIndex() == 0);
        assert (byteBuf.readerIndex() == 0);
        ByteBuf byteBuf2 = PlatformDependent.hasUnsafe() ? byteBuf : (this.memory = byteBuf.order(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN));
        if (byteBuf.hasMemoryAddress()) {
            this.memoryAddress = byteBuf.memoryAddress();
            return;
        }
        this.memoryAddress = Buffer.memoryAddress(byteBuf.internalNioBuffer(0, byteBuf.capacity()));
    }

    public final void clear() {
        this.count = 0;
        this.size = 0L;
    }

    @Deprecated
    public final boolean add(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return this.add(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public final boolean add(ByteBuf object, int n, int n2) {
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (object.nioBufferCount() == 1) {
            if (n2 == 0) {
                return true;
            }
            if (object.hasMemoryAddress()) {
                IovArray iovArray = this;
                return iovArray.add(iovArray.memoryAddress, object.memoryAddress() + (long)n, n2);
            }
            object = object.internalNioBuffer(n, n2);
            IovArray iovArray = this;
            return iovArray.add(iovArray.memoryAddress, Buffer.memoryAddress((ByteBuffer)object) + (long)((java.nio.Buffer)object).position(), n2);
        }
        ByteBuffer[] byteBufferArray = object.nioBuffers(n, n2);
        object = byteBufferArray;
        object = byteBufferArray;
        n = byteBufferArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            Object object2 = object[n2];
            int n3 = ((java.nio.Buffer)object2).remaining();
            if (n3 == 0) continue;
            IovArray iovArray = this;
            if (iovArray.add(iovArray.memoryAddress, Buffer.memoryAddress((ByteBuffer)object2) + (long)((java.nio.Buffer)object2).position(), n3) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long l, long l2, int n) {
        assert (l2 != 0L);
        if (this.maxBytes - (long)n < this.size && this.count > 0 || this.memory.capacity() < (this.count + 1) * IOV_SIZE) {
            return false;
        }
        int n2 = IovArray.idx(this.count);
        int n3 = n2 + ADDRESS_SIZE;
        this.size += (long)n;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)((long)n2 + l), (long)l2);
                PlatformDependent.putLong((long)((long)n3 + l), (long)n);
            } else {
                this.memory.setLong(n2, l2);
                this.memory.setLong(n3, (long)n);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putInt((long)((long)n2 + l), (int)((int)l2));
                PlatformDependent.putInt((long)((long)n3 + l), (int)n);
            } else {
                this.memory.setInt(n2, (int)l2);
                this.memory.setInt(n3, n);
            }
        }
        return true;
    }

    public final int count() {
        return this.count;
    }

    public final long size() {
        return this.size;
    }

    public final void maxBytes(long l) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive((long)l, (String)"maxBytes"));
    }

    public final long maxBytes() {
        return this.maxBytes;
    }

    public final long memoryAddress(int n) {
        return this.memoryAddress + (long)IovArray.idx(n);
    }

    public final void release() {
        this.memory.release();
    }

    public final boolean processMessage(Object object) {
        if (object instanceof ByteBuf) {
            Object object2 = object = (ByteBuf)object;
            return this.add((ByteBuf)object2, object2.readerIndex(), object.readableBytes());
        }
        return false;
    }

    private static int idx(int n) {
        return IOV_SIZE * n;
    }
}

