/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;

public final class StanzaCollector
implements AutoCloseable {
    private final StanzaFilter packetFilter;
    private final ArrayDeque<Stanza> resultQueue;
    private final int maxQueueSize;
    private final StanzaCollector collectorToReset;
    private final XMPPConnection connection;
    private final Stanza request;
    private volatile boolean cancelled;
    private Exception connectionException;
    private volatile long waitStart;
    private List<Stanza> collectedCache;
    private String stringCache;

    StanzaCollector(XMPPConnection xMPPConnection, Configuration configuration) {
        this.connection = xMPPConnection;
        this.packetFilter = configuration.packetFilter;
        this.resultQueue = new ArrayDeque(configuration.size);
        this.maxQueueSize = configuration.size;
        this.collectorToReset = configuration.collectorToReset;
        this.request = configuration.request;
    }

    public final synchronized void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.connection.removeStanzaCollector(this);
        this.notifyAll();
        if (this.collectorToReset != null) {
            this.collectorToReset.cancel();
        }
    }

    public final StanzaFilter getStanzaFilter() {
        return this.packetFilter;
    }

    public final synchronized <P extends Stanza> P pollResult() {
        return (P)this.resultQueue.poll();
    }

    public final <P extends Stanza> P pollResultOrThrow() {
        P p = this.pollResult();
        if (p != null) {
            XMPPException.XMPPErrorException.ifHasErrorThenThrow(p);
        }
        return p;
    }

    public final synchronized <P extends Stanza> P nextResultBlockForever() {
        this.throwIfCancelled();
        Stanza stanza;
        while ((stanza = this.resultQueue.poll()) == null) {
            if (this.cancelled) {
                return null;
            }
            this.wait();
        }
        return (P)stanza;
    }

    public final <P extends Stanza> P nextResult() {
        StanzaCollector stanzaCollector = this;
        return stanzaCollector.nextResult(stanzaCollector.connection.getReplyTimeout());
    }

    public final <P extends Stanza> P nextResult(long l) {
        this.throwIfCancelled();
        Stanza stanza = null;
        long l2 = l;
        this.waitStart = System.currentTimeMillis();
        while (l2 > 0L && this.connectionException == null && !this.cancelled) {
            StanzaCollector stanzaCollector = this;
            synchronized (stanzaCollector) {
                stanza = this.resultQueue.poll();
                if (stanza != null) {
                    return (P)stanza;
                }
                this.wait(l2);
            }
            l2 = l - (System.currentTimeMillis() - this.waitStart);
        }
        return (P)stanza;
    }

    public final <P extends Stanza> P nextResultOrThrow() {
        StanzaCollector stanzaCollector = this;
        return stanzaCollector.nextResultOrThrow(stanzaCollector.connection.getReplyTimeout());
    }

    public final <P extends Stanza> P nextResultOrThrow(long l) {
        P p;
        try {
            p = this.nextResult(l);
        }
        finally {
            this.cancel();
        }
        if (p == null) {
            if (this.connectionException != null) {
                throw new SmackException.NotConnectedException(this.connection, this.packetFilter, this.connectionException);
            }
            if (!this.connection.isConnected()) {
                throw new SmackException.NotConnectedException(this.connection, this.packetFilter);
            }
            StanzaCollector stanzaCollector = this;
            throw SmackException.NoResponseException.newWith(l, stanzaCollector, stanzaCollector.cancelled);
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow(p);
        return p;
    }

    public final List<Stanza> getCollectedStanzasAfterCancelled() {
        if (!this.cancelled) {
            throw new IllegalStateException("Stanza collector was not yet cancelled");
        }
        if (this.collectedCache == null) {
            this.collectedCache = new ArrayList<Stanza>(this.getCollectedCount());
            this.collectedCache.addAll(this.resultQueue);
        }
        return this.collectedCache;
    }

    public final synchronized int getCollectedCount() {
        return this.resultQueue.size();
    }

    public final String toString() {
        if (this.stringCache == null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Stanza Collector filter='").append(this.packetFilter).append('\'');
            if (this.request != null) {
                stringBuilder.append(" request='").append(this.request).append('\'');
            }
            this.stringCache = stringBuilder.toString();
        }
        return this.stringCache;
    }

    final synchronized void notifyConnectionError(Exception exception) {
        this.connectionException = exception;
        this.notifyAll();
    }

    protected final void processStanza(Stanza stanza) {
        if (this.packetFilter == null || this.packetFilter.accept(stanza)) {
            StanzaCollector stanzaCollector = this;
            synchronized (stanzaCollector) {
                if (this.resultQueue.size() == this.maxQueueSize) {
                    Stanza stanza2 = this.resultQueue.poll();
                    assert (stanza2 != null);
                }
                this.resultQueue.add(stanza);
                this.notifyAll();
            }
            if (this.collectorToReset != null) {
                this.collectorToReset.waitStart = System.currentTimeMillis();
            }
        }
    }

    private void throwIfCancelled() {
        if (this.cancelled) {
            throw new IllegalStateException("Stanza collector already cancelled");
        }
    }

    public static Configuration newConfiguration() {
        return new Configuration();
    }

    @Override
    public final void close() {
        this.cancel();
    }

    public static final class Configuration {
        private StanzaFilter packetFilter;
        private int size = SmackConfiguration.getStanzaCollectorSize();
        private StanzaCollector collectorToReset;
        private Stanza request;

        private Configuration() {
        }

        public final Configuration setStanzaFilter(StanzaFilter stanzaFilter) {
            this.packetFilter = stanzaFilter;
            return this;
        }

        public final Configuration setSize(int n) {
            this.size = n;
            return this;
        }

        public final Configuration setCollectorToReset(StanzaCollector stanzaCollector) {
            this.collectorToReset = stanzaCollector;
            return this;
        }

        public final Configuration setRequest(Stanza stanza) {
            this.request = stanza;
            return this;
        }
    }
}

