/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.AbstractDebugger;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.util.ExceptionUtil;

public class ConsoleDebugger
extends AbstractDebugger {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss");

    public ConsoleDebugger(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
    }

    @Override
    protected void log(String string) {
        String string2;
        SimpleDateFormat simpleDateFormat = this.dateFormatter;
        synchronized (simpleDateFormat) {
            string2 = this.dateFormatter.format(new Date());
        }
        System.out.println(string2 + ' ' + string);
    }

    @Override
    protected void log(String string, Throwable object) {
        object = ExceptionUtil.getStackTrace((Throwable)object);
        this.log(string + '\n' + (String)object);
    }

    public static final class Factory
    implements SmackDebuggerFactory {
        public static final SmackDebuggerFactory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public final SmackDebugger create(XMPPConnection xMPPConnection) {
            return new ConsoleDebugger(xMPPConnection);
        }
    }
}

