/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import org.jivesoftware.smack.fsm.StateDescriptor;

public abstract class StateTransitionResult {
    private final String message;

    protected StateTransitionResult(String string) {
        this.message = string;
    }

    public String toString() {
        return this.message;
    }

    public static class TransitionImpossibleBecauseNotImplemented
    extends TransitionImpossibleReason {
        public TransitionImpossibleBecauseNotImplemented(StateDescriptor stateDescriptor) {
            super(stateDescriptor.getFullStateName(false) + " is not implemented (yet)");
        }
    }

    public static class TransitionImpossibleReason
    extends TransitionImpossible {
        public TransitionImpossibleReason(String string) {
            super(string);
        }
    }

    public static abstract class TransitionImpossible
    extends StateTransitionResult {
        protected TransitionImpossible(String string) {
            super(string);
        }
    }

    public static final class FailureCausedByTimeout
    extends Failure {
        public FailureCausedByTimeout(String string) {
            super(string);
        }
    }

    public static final class FailureCausedByException<E extends Exception>
    extends Failure {
        private final E exception;

        public FailureCausedByException(E e2) {
            super(((Throwable)e2).getMessage());
            this.exception = e2;
        }

        public final E getException() {
            return this.exception;
        }
    }

    public static class Failure
    extends AttemptResult {
        public Failure(String string) {
            super(string);
        }
    }

    public static class Success
    extends AttemptResult {
        public static final Success EMPTY_INSTANCE = new Success();

        private Success() {
            super("");
        }

        public Success(String string) {
            super(string);
        }
    }

    public static abstract class AttemptResult
    extends StateTransitionResult {
        protected AttemptResult(String string) {
            super(string);
        }
    }
}

