/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.initializer;

import java.io.InputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.provider.ProviderFileLoader;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;

public abstract class UrlInitializer
implements SmackInitializer {
    private static final Logger LOGGER = Logger.getLogger(UrlInitializer.class.getName());

    @Override
    public List<Exception> initialize() {
        Object object;
        InputStream inputStream = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        LinkedList<Exception> linkedList = new LinkedList<Exception>();
        String string = this.getProvidersUri();
        if (string != null) {
            try {
                object = URI.create(string);
                inputStream = FileUtils.getStreamForUri((URI)object, classLoader);
                LOGGER.log(Level.FINE, "Loading providers for providerUri [" + object + "]");
                object = new ProviderFileLoader(inputStream, classLoader);
                ProviderManager.addLoader((ProviderLoader)object);
                linkedList.addAll(((ProviderFileLoader)object).getLoadingExceptions());
            }
            catch (Exception exception) {
                try {
                    LOGGER.log(Level.SEVERE, "Error trying to load provider file " + string, exception);
                    linkedList.add(exception);
                }
                catch (Throwable throwable) {
                    UrlInitializer.maybeClose(inputStream);
                    throw throwable;
                }
                UrlInitializer.maybeClose(inputStream);
            }
            UrlInitializer.maybeClose(inputStream);
        }
        if ((object = this.getConfigUri()) != null) {
            try {
                object = URI.create((String)object);
                inputStream = FileUtils.getStreamForUri((URI)object, classLoader);
                SmackInitialization.processConfigFile(inputStream, linkedList, classLoader);
            }
            catch (Exception exception) {
                linkedList.add(exception);
            }
            finally {
                UrlInitializer.maybeClose(inputStream);
            }
        }
        return linkedList;
    }

    protected String getProvidersUri() {
        return null;
    }

    protected String getConfigUri() {
        return null;
    }

    private static void maybeClose(InputStream inputStream) {
        CloseableUtil.maybeClose(inputStream, LOGGER);
    }
}

