/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageOrPresenceBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.ToStringUtil;

public final class MessageBuilder
extends MessageOrPresenceBuilder<Message, MessageBuilder>
implements MessageView {
    static final MessageBuilder EMPTY = new MessageBuilder(() -> null);
    Message.Type type;

    MessageBuilder(Message message, String string) {
        super((Stanza)message, string);
        this.copyFromMessage(message);
    }

    MessageBuilder(Message message, StanzaIdSource stanzaIdSource) {
        super((Stanza)message, stanzaIdSource);
        this.copyFromMessage(message);
    }

    MessageBuilder(StanzaIdSource stanzaIdSource) {
        super(stanzaIdSource);
    }

    MessageBuilder(String string) {
        super(string);
    }

    private void copyFromMessage(Message message) {
        this.type = message.getType();
    }

    @Override
    protected final void addStanzaSpecificAttributes(ToStringUtil.Builder builder) {
        builder.addValue("type", (Object)this.type);
    }

    public final MessageBuilder ofType(Message.Type type) {
        this.type = type;
        return this.getThis();
    }

    public final MessageBuilder setThread(String string) {
        return this.setThread(string, null);
    }

    public final MessageBuilder setThread(String string, String string2) {
        this.addExtension(new Message.Thread(string, string2));
        return this.getThis();
    }

    public final MessageBuilder setSubject(String string) {
        return this.addSubject(null, string);
    }

    public final MessageBuilder addSubject(String string, String string2) {
        string = StringUtils.requireNullOrNotEmpty(string, "language must be null or not empty");
        for (Message.Subject subject : this.getExtensions(Message.Subject.class)) {
            if (!StringUtils.nullSafeCharSequenceEquals(string, subject.getLanguage())) continue;
            throw new IllegalArgumentException("Subject with the language " + string + " already exists");
        }
        Message.Subject subject = new Message.Subject(string, string2);
        this.addExtension(subject);
        return this;
    }

    public final MessageBuilder setBody(CharSequence charSequence) {
        return this.setBody(charSequence.toString());
    }

    public final MessageBuilder setBody(String string) {
        return this.addBody(null, string);
    }

    public final MessageBuilder addBody(String string, String string2) {
        string = StringUtils.requireNullOrNotEmpty(string, "language must be null or not empty");
        for (Message.Body body : this.getExtensions(Message.Body.class)) {
            if (!StringUtils.nullSafeCharSequenceEquals(string, body.getLanguage())) continue;
            throw new IllegalArgumentException("Bodyt with the language " + string + " already exists");
        }
        Message.Body body = new Message.Body(string, string2);
        this.addExtension(body);
        return this;
    }

    @Override
    public final MessageBuilder getThis() {
        return this;
    }

    @Override
    public final Message build() {
        return new Message(this);
    }

    @Override
    public final Message.Type getType() {
        return this.type;
    }
}

