/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class ProviderFileLoader
implements ProviderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProviderFileLoader.class.getName());
    private final Collection<IQProviderInfo> iqProviders = new LinkedList<IQProviderInfo>();
    private final Collection<ExtensionProviderInfo> extProviders = new LinkedList<ExtensionProviderInfo>();
    private final Collection<StreamFeatureProviderInfo> sfProviders = new LinkedList<StreamFeatureProviderInfo>();
    private List<Exception> exceptions = new LinkedList<Exception>();

    public ProviderFileLoader(InputStream inputStream) {
        this(inputStream, ProviderFileLoader.class.getClassLoader());
    }

    public ProviderFileLoader(InputStream inputStream, ClassLoader classLoader) {
        try {
            block26: {
                block25: {
                    try {
                        XmlPullParser xmlPullParser = PacketParserUtils.getParserFor(inputStream);
                        Object object = xmlPullParser.getEventType();
                        block21: do {
                            if (object != XmlPullParser.Event.START_ELEMENT) continue;
                            object = xmlPullParser.getName();
                            try {
                                if ("smackProviders".equals(object)) continue;
                                xmlPullParser.next();
                                xmlPullParser.next();
                                String string = xmlPullParser.nextText();
                                xmlPullParser.next();
                                xmlPullParser.next();
                                String string2 = xmlPullParser.nextText();
                                xmlPullParser.next();
                                xmlPullParser.next();
                                String string3 = xmlPullParser.nextText();
                                try {
                                    Object object2 = classLoader.loadClass(string3);
                                    switch (object) {
                                        case "iqProvider": {
                                            if (IqProvider.class.isAssignableFrom((Class<?>)object2)) {
                                                object2 = (IqProvider)((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
                                                this.iqProviders.add(new IQProviderInfo(string, string2, (IqProvider<IQ>)object2));
                                                continue block21;
                                            }
                                            this.exceptions.add(new IllegalArgumentException(string3 + " is not a IQProvider"));
                                            continue block21;
                                        }
                                        case "extensionProvider": {
                                            if (ExtensionElementProvider.class.isAssignableFrom((Class<?>)object2)) {
                                                object2 = (ExtensionElementProvider)((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
                                                this.extProviders.add(new ExtensionProviderInfo(string, string2, (ExtensionElementProvider<ExtensionElement>)object2));
                                                continue block21;
                                            }
                                            this.exceptions.add(new IllegalArgumentException(string3 + " is not a PacketExtensionProvider"));
                                            continue block21;
                                        }
                                        case "streamFeatureProvider": {
                                            object2 = (ExtensionElementProvider)((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
                                            this.sfProviders.add(new StreamFeatureProviderInfo(string, string2, (ExtensionElementProvider<ExtensionElement>)object2));
                                            continue block21;
                                        }
                                        default: {
                                            LOGGER.warning("Unknown provider type: " + (String)object);
                                            break;
                                        }
                                    }
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    LOGGER.log(Level.SEVERE, "Could not find provider class", classNotFoundException);
                                    this.exceptions.add(classNotFoundException);
                                }
                                catch (InstantiationException instantiationException) {
                                    LOGGER.log(Level.SEVERE, "Could not instanciate " + string3, instantiationException);
                                    this.exceptions.add(instantiationException);
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                LOGGER.log(Level.SEVERE, "Invalid provider type found [" + (String)object + "] when expecting iqProvider or extensionProvider", illegalArgumentException);
                                this.exceptions.add(illegalArgumentException);
                            }
                        } while ((object = xmlPullParser.next()) != XmlPullParser.Event.END_DOCUMENT);
                        if (inputStream == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block26;
                }
                return;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Unknown error occurred while parsing provider file", exception);
            this.exceptions.add(exception);
        }
    }

    @Override
    public Collection<IQProviderInfo> getIQProviderInfo() {
        return this.iqProviders;
    }

    @Override
    public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
        return this.extProviders;
    }

    @Override
    public Collection<StreamFeatureProviderInfo> getStreamFeatureProviderInfo() {
        return this.sfProviders;
    }

    public List<Exception> getLoadingExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

