/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.jivesoftware.smack.proxy.ProxySocketConnection;

public class ProxyInfo {
    private String proxyAddress;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private ProxyType proxyType;
    private final ProxySocketConnection proxySocketConnection;

    public ProxyInfo(ProxyType proxyType, String string, int n, String string2, String string3) {
        this.proxyType = proxyType;
        this.proxyAddress = string;
        this.proxyPort = n;
        this.proxyUsername = string2;
        this.proxyPassword = string3;
        this.proxySocketConnection = ProxySocketConnection.forProxyType(this.proxyType).apply(this);
    }

    public static ProxyInfo forHttpProxy(String string, int n, String string2, String string3) {
        return new ProxyInfo(ProxyType.HTTP, string, n, string2, string3);
    }

    public static ProxyInfo forSocks4Proxy(String string, int n, String string2, String string3) {
        return new ProxyInfo(ProxyType.SOCKS4, string, n, string2, string3);
    }

    public static ProxyInfo forSocks5Proxy(String string, int n, String string2, String string3) {
        return new ProxyInfo(ProxyType.SOCKS5, string, n, string2, string3);
    }

    public Proxy.Type getJavaProxyType() {
        switch (this.proxyType) {
            case HTTP: {
                return Proxy.Type.HTTP;
            }
            case SOCKS4: 
            case SOCKS5: {
                return Proxy.Type.SOCKS;
            }
        }
        throw new AssertionError((Object)("Invalid proxy type: " + (Object)((Object)this.proxyType)));
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public ProxySocketConnection getProxySocketConnection() {
        return this.proxySocketConnection;
    }

    public Proxy toJavaProxy() {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.proxyAddress, this.proxyPort);
        Proxy.Type type = this.getJavaProxyType();
        return new Proxy(type, inetSocketAddress);
    }

    public static enum ProxyType {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

