/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h.b.a;
import org.h.d.e;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;

public abstract class DNSResolver {
    protected static final Logger LOGGER = Logger.getLogger(DNSResolver.class.getName());
    private final boolean supportsDnssec;

    protected DNSResolver(boolean bl) {
        this.supportsDnssec = bl;
    }

    public final Collection<e> lookupSrvRecords(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        return this.lookupSrvRecords0(a2, list, dnssecMode);
    }

    protected abstract Collection<e> lookupSrvRecords0(a var1, List<RemoteConnectionEndpointLookupFailure> var2, ConnectionConfiguration.DnssecMode var3);

    public final List<InetAddress> lookupHostAddress(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        return this.lookupHostAddress0(a2, list, dnssecMode);
    }

    protected List<InetAddress> lookupHostAddress0(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode inetAddressArray) {
        if (inetAddressArray != ConnectionConfiguration.DnssecMode.disabled) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(a2.toString());
        }
        catch (UnknownHostException unknownHostException) {
            list.add(new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(a2, (Exception)unknownHostException));
            return null;
        }
        return Arrays.asList(inetAddressArray);
    }

    protected static boolean shouldContinue(CharSequence charSequence, CharSequence charSequence2, List<InetAddress> list) {
        if (list == null) {
            return true;
        }
        if (list.isEmpty()) {
            LOGGER.log(Level.INFO, "The DNS name " + charSequence + ", points to a hostname (" + charSequence2 + ") which has neither A or AAAA resource records. This is an indication of a broken DNS setup.");
            return true;
        }
        return false;
    }

    private void checkIfDnssecRequestedAndSupported(ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled && !this.supportsDnssec) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
    }
}

