/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Lz4XXHash32;
import io.netty.util.internal.ObjectUtil;
import java.util.List;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class Lz4FrameDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private LZ4FastDecompressor decompressor;
    private ByteBufChecksum checksum;
    private int blockType;
    private int compressedLength;
    private int decompressedLength;
    private int currentChecksum;

    public Lz4FrameDecoder() {
        this(false);
    }

    public Lz4FrameDecoder(boolean bl) {
        this(LZ4Factory.fastestInstance(), bl);
    }

    public Lz4FrameDecoder(LZ4Factory lZ4Factory, boolean bl) {
        this(lZ4Factory, bl ? new Lz4XXHash32(-1756908916) : null);
    }

    public Lz4FrameDecoder(LZ4Factory lZ4Factory, Checksum checksum) {
        this.decompressor = ((LZ4Factory)ObjectUtil.checkNotNull((Object)lZ4Factory, (String)"factory")).fastDecompressor();
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum(checksum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (byteBuf.readableBytes() < 21) return;
                    long l = byteBuf.readLong();
                    if (l != 5501767354678207339L) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte by = byteBuf.readByte();
                    int n = by;
                    int n2 = (by & 0xF) + 10;
                    n &= 0xF0;
                    int n3 = Integer.reverseBytes(byteBuf.readInt());
                    if (n3 < 0 || n3 > 0x2000000) {
                        throw new DecompressionException(String.format("invalid compressedLength: %d (expected: 0-%d)", n3, 0x2000000));
                    }
                    int n4 = Integer.reverseBytes(byteBuf.readInt());
                    n2 = 1 << n2;
                    if (n4 < 0 || n4 > n2) {
                        throw new DecompressionException(String.format("invalid decompressedLength: %d (expected: 0-%d)", n4, n2));
                    }
                    if (n4 == 0 && n3 != 0 || n4 != 0 && n3 == 0 || n == 16 && n4 != n3) {
                        throw new DecompressionException(String.format("stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", n3, n4));
                    }
                    n2 = Integer.reverseBytes(byteBuf.readInt());
                    if (n4 == 0 && n3 == 0) {
                        if (n2 != 0) {
                            throw new DecompressionException("stream corrupted: checksum error");
                        }
                        this.currentState = State.FINISHED;
                        this.decompressor = null;
                        this.checksum = null;
                        return;
                    }
                    this.blockType = n;
                    this.compressedLength = n3;
                    this.decompressedLength = n4;
                    this.currentChecksum = n2;
                    this.currentState = State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int n = this.blockType;
                    int n3 = this.compressedLength;
                    int n4 = this.decompressedLength;
                    int n2 = this.currentChecksum;
                    if (byteBuf.readableBytes() < n3) return;
                    ByteBufChecksum byteBufChecksum = this.checksum;
                    ByteBuf byteBuf2 = null;
                    try {
                        try {
                            switch (n) {
                                case 16: {
                                    ByteBuf byteBuf3 = byteBuf;
                                    byteBuf2 = byteBuf3.retainedSlice(byteBuf3.readerIndex(), n4);
                                    break;
                                }
                                case 32: {
                                    int n5 = n4;
                                    ByteBuf byteBuf4 = byteBuf2 = channelHandlerContext.alloc().buffer(n5, n5);
                                    this.decompressor.decompress(CompressionUtil.safeReadableNioBuffer(byteBuf), byteBuf4.internalNioBuffer(byteBuf4.writerIndex(), n4));
                                    ByteBuf byteBuf5 = byteBuf2;
                                    byteBuf5.writerIndex(byteBuf5.writerIndex() + n4);
                                    break;
                                }
                                default: {
                                    throw new DecompressionException(String.format("unexpected blockType: %d (expected: %d or %d)", n, 16, 32));
                                }
                            }
                            byteBuf.skipBytes(n3);
                            if (byteBufChecksum != null) {
                                CompressionUtil.checkChecksum(byteBufChecksum, byteBuf2, n2);
                            }
                            list.add(byteBuf2);
                            byteBuf2 = null;
                            this.currentState = State.INIT_BLOCK;
                            return;
                        }
                        catch (LZ4Exception lZ4Exception) {
                            throw new DecompressionException(lZ4Exception);
                        }
                    }
                    catch (Throwable throwable) {
                        if (byteBuf2 == null) throw throwable;
                        byteBuf2.release();
                        throw throwable;
                    }
                }
                case FINISHED: 
                case CORRUPTED: {
                    ByteBuf byteBuf6 = byteBuf;
                    byteBuf6.skipBytes(byteBuf6.readableBytes());
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = State.CORRUPTED;
            throw exception;
        }
    }

    public boolean isClosed() {
        return this.currentState == State.FINISHED;
    }

    private static enum State {
        INIT_BLOCK,
        DECOMPRESS_DATA,
        FINISHED,
        CORRUPTED;

    }
}

