/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.string.LineSeparator;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class LineEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;
    private final byte[] lineSeparator;

    public LineEncoder() {
        this(LineSeparator.DEFAULT, CharsetUtil.UTF_8);
    }

    public LineEncoder(LineSeparator lineSeparator) {
        this(lineSeparator, CharsetUtil.UTF_8);
    }

    public LineEncoder(Charset charset) {
        this(LineSeparator.DEFAULT, charset);
    }

    public LineEncoder(LineSeparator lineSeparator, Charset charset) {
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.lineSeparator = ((LineSeparator)ObjectUtil.checkNotNull((Object)lineSeparator, (String)"lineSeparator")).value().getBytes(charset);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, CharSequence charSequence, List<Object> list) {
        channelHandlerContext = ByteBufUtil.encodeString((ByteBufAllocator)channelHandlerContext.alloc(), (CharBuffer)CharBuffer.wrap(charSequence), (Charset)this.charset, (int)this.lineSeparator.length);
        channelHandlerContext.writeBytes(this.lineSeparator);
        list.add(channelHandlerContext);
    }
}

