/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.e.a.i;
import org.e.c.a.c;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.BoBInfo;
import org.jivesoftware.smackx.bob.ContentId;
import org.jivesoftware.smackx.bob.element.BoBIQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class BoBManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:bob";
    private static final Map<XMPPConnection, BoBManager> INSTANCES;
    private static final c<ContentId, BoBData> BOB_CACHE;
    private final Map<ContentId, BoBInfo> bobs = new ConcurrentHashMap<ContentId, BoBInfo>();

    public static synchronized BoBManager getInstanceFor(XMPPConnection xMPPConnection) {
        BoBManager boBManager = INSTANCES.get(xMPPConnection);
        if (boBManager == null) {
            boBManager = new BoBManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, boBManager);
        }
        return boBManager;
    }

    private BoBManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("data", NAMESPACE, IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                iQ = (BoBIQ)iQ;
                Object object = iQ.getContentId();
                Object object2 = (BoBInfo)BoBManager.this.bobs.get(object);
                if (object2 == null) {
                    return null;
                }
                object2 = ((BoBInfo)object2).getData();
                object = new BoBIQ((ContentId)object, (BoBData)object2);
                object.setType(IQ.Type.result);
                object.setTo(iQ.getFrom());
                return object;
            }
        });
    }

    public final boolean isSupportedByServer() {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    public final BoBData requestBoB(i object, ContentId contentId) {
        ContentId contentId2 = contentId;
        Object object2 = BOB_CACHE;
        if ((object2 = (BoBData)object2.get((Object)contentId2)) != null) {
            return object2;
        }
        object2 = new BoBIQ(contentId);
        object2.setType(IQ.Type.get);
        object2.setTo(object);
        object = this.getAuthenticatedConnectionOrThrow();
        object = (BoBIQ)object.createStanzaCollectorAndSend(object2).nextResultOrThrow();
        object2 = object.getBoBData();
        BOB_CACHE.put((Object)contentId, object2);
        return object2;
    }

    public final BoBInfo addBoB(BoBData object) {
        ContentId contentId = new ContentId(SHA1.hex((byte[])((BoBData)object).getContent()), "sha1");
        Set<ContentId> set = Collections.singleton(contentId);
        set = Collections.unmodifiableSet(set);
        object = new BoBInfo(set, (BoBData)object);
        this.bobs.put(contentId, (BoBInfo)object);
        return object;
    }

    public final BoBInfo removeBoB(ContentId object) {
        if ((object = this.bobs.remove(object)) == null) {
            return null;
        }
        for (ContentId contentId : ((BoBInfo)object).getHashes()) {
            this.bobs.remove(contentId);
        }
        return object;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                BoBManager.getInstanceFor(xMPPConnection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, BoBManager>();
        BOB_CACHE = new c(128);
    }
}

