/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public class Socks5Client {
    private static final Logger LOGGER = Logger.getLogger(Socks5Client.class.getName());
    protected Bytestream.StreamHost streamHost;
    protected String digest;

    public Socks5Client(Bytestream.StreamHost streamHost, String string) {
        this.streamHost = streamHost;
        this.digest = string;
    }

    public Socket getSocket(int n) {
        FutureTask<Socket> futureTask = new FutureTask<Socket>(new Callable<Socket>(){

            @Override
            public Socket call() {
                Socket socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(Socks5Client.this.streamHost.getAddress().asInetAddress(), Socks5Client.this.streamHost.getPort());
                socket.connect(inetSocketAddress);
                try {
                    Socks5Client.this.establish(socket);
                }
                catch (SmackException.SmackMessageException smackMessageException) {
                    if (!socket.isClosed()) {
                        CloseableUtil.maybeClose((Closeable)socket, (Logger)LOGGER);
                    }
                    throw smackMessageException;
                }
                return socket;
            }
        });
        Async.go(futureTask, (String)("SOCKS5 client connecting to " + this.streamHost));
        try {
            return futureTask.get(n, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            throw new IOException("ExecutionException while SOCKS5 client attempting to connect to " + this.streamHost, executionException);
        }
    }

    protected void establish(Socket object) {
        Object object2 = new DataInputStream(((Socket)object).getInputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object).getOutputStream());
        byte[] byArray = new byte[3];
        object = byArray;
        byArray[0] = 5;
        object[1] = true;
        object[2] = false;
        dataOutputStream.write((byte[])object);
        dataOutputStream.flush();
        object = new byte[2];
        ((DataInputStream)object2).readFully((byte[])object);
        if (object[0] != 5 || object[1] != false) {
            throw new SmackException.SmackMessageException("Remote SOCKS5 server responded with unexpected version: " + (int)object[0] + ' ' + (int)object[1] + ". Should be 0x05 0x00.");
        }
        object = this.createSocks5ConnectRequest();
        dataOutputStream.write((byte[])object);
        dataOutputStream.flush();
        object2 = Socks5Utils.receiveSocks5Message((DataInputStream)object2);
        object[1] = false;
        if (!Arrays.equals((byte[])object, (byte[])object2)) {
            throw new SmackException.SmackMessageException("Connection request does not equal connection response. Response: " + Arrays.toString((byte[])object2) + ". Request: " + Arrays.toString((byte[])object));
        }
    }

    private byte[] createSocks5ConnectRequest() {
        byte[] byArray = this.digest.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = new byte[7 + byArray.length];
        byte[] byArray3 = byArray2;
        byArray2[0] = 5;
        byArray3[1] = 1;
        byArray3[2] = 0;
        byArray3[3] = 3;
        byArray3[4] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, 5, byArray.length);
        byArray3[byArray3.length - 2] = 0;
        byArray3[byArray3.length - 1] = 0;
        return byArray3;
    }
}

