/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.lang.ref.WeakReference;
import java.net.Socket;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public class Socks5ClientForInitiator
extends Socks5Client {
    private WeakReference<XMPPConnection> connection;
    private String sessionID;
    private final i target;

    public Socks5ClientForInitiator(Bytestream.StreamHost streamHost, String string, XMPPConnection xMPPConnection, String string2, i i2) {
        super(streamHost, string);
        this.connection = new WeakReference<XMPPConnection>(xMPPConnection);
        this.sessionID = string2;
        this.target = i2;
    }

    @Override
    public Socket getSocket(int n) {
        Socket socket;
        if (this.streamHost.getJID().a((CharSequence)((XMPPConnection)this.connection.get()).getUser())) {
            socket = Socks5Proxy.getSocketForDigest(this.digest);
            if (socket == null) {
                throw new SmackException.SmackMessageException("target is not connected to SOCKS5 proxy");
            }
        } else {
            socket = super.getSocket(n);
            try {
                this.activate();
            }
            catch (XMPPException xMPPException) {
                socket.close();
                throw xMPPException;
            }
            catch (SmackException.NoResponseException noResponseException) {
                socket.close();
                throw noResponseException;
            }
        }
        return socket;
    }

    private void activate() {
        Bytestream bytestream = this.createStreamHostActivation();
        ((XMPPConnection)this.connection.get()).createStanzaCollectorAndSend((IQ)bytestream).nextResultOrThrow();
    }

    private Bytestream createStreamHostActivation() {
        Bytestream bytestream = new Bytestream(this.sessionID);
        bytestream.setMode(null);
        bytestream.setType(IQ.Type.set);
        bytestream.setTo(this.streamHost.getJID());
        bytestream.setToActivate(this.target);
        return bytestream;
    }
}

