/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.e;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.chat2.OutgoingChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.ChatStateListener;
import org.jivesoftware.smackx.chatstates.packet.ChatStateExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class ChatStateManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ChatStateManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/chatstates";
    private static final Map<XMPPConnection, ChatStateManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatStateManager>();
    private static final StanzaFilter INCOMING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT, FromTypeFilter.ENTITY_FULL_JID});
    private static final StanzaFilter INCOMING_CHAT_STATE_FILTER = new AndFilter(new StanzaFilter[]{INCOMING_MESSAGE_FILTER, new StanzaExtensionFilter("http://jabber.org/protocol/chatstates")});
    private final Set<ChatStateListener> chatStateListeners = new HashSet<ChatStateListener>();
    private final Map<Chat, ChatState> chatStates = new WeakHashMap<Chat, ChatState>();
    private final AsyncButOrdered<Chat> asyncButOrdered = new AsyncButOrdered();

    public static synchronized ChatStateManager getInstance(XMPPConnection xMPPConnection) {
        ChatStateManager chatStateManager = INSTANCES.get(xMPPConnection);
        if (chatStateManager == null) {
            chatStateManager = new ChatStateManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, chatStateManager);
        }
        return chatStateManager;
    }

    private ChatStateManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ChatManager chatManager = ChatManager.getInstanceFor(xMPPConnection);
        chatManager.addOutgoingListener(new OutgoingChatMessageListener(){

            @Override
            public void newOutgoingMessage(e e2, MessageBuilder messageBuilder, Chat chat) {
                if (chat == null) {
                    return;
                }
                if (messageBuilder.hasExtension(ChatStateManager.NAMESPACE)) {
                    return;
                }
                if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                    messageBuilder.addExtension((ExtensionElement)new ChatStateExtension(ChatState.active));
                }
            }
        });
        xMPPConnection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                ChatState chatState;
                stanza = (Message)stanza;
                Object object = stanza.getFrom().q();
                object = object.b();
                object = ChatManager.getInstanceFor(ChatStateManager.this.connection()).chatWith((e)object);
                Object object2 = stanza.getExtension(ChatStateManager.NAMESPACE);
                object2 = object2.getElementName();
                try {
                    chatState = ChatState.valueOf((String)object2);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Invalid chat state element name: " + (String)object2, exception);
                    return;
                }
                Set set = ChatStateManager.this.chatStateListeners;
                synchronized (set) {
                    object2 = new ArrayList(ChatStateManager.this.chatStateListeners.size());
                    object2.addAll(ChatStateManager.this.chatStateListeners);
                }
                set = object2;
                ChatStateManager.this.asyncButOrdered.performAsyncButOrdered(object, new Runnable((List)((Object)set), (Chat)((Object)object), chatState, (Message)stanza){
                    final /* synthetic */ List val$finalListeners;
                    final /* synthetic */ Chat val$chat;
                    final /* synthetic */ ChatState val$finalState;
                    final /* synthetic */ Message val$message;
                    {
                        this.val$finalListeners = list;
                        this.val$chat = chat;
                        this.val$finalState = chatState;
                        this.val$message = message;
                    }

                    @Override
                    public void run() {
                        for (ChatStateListener chatStateListener : this.val$finalListeners) {
                            chatStateListener.stateChanged(this.val$chat, this.val$finalState, this.val$message);
                        }
                    }
                });
            }
        }, INCOMING_CHAT_STATE_FILTER);
        ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature(NAMESPACE);
    }

    public final boolean addChatStateListener(ChatStateListener chatStateListener) {
        Set<ChatStateListener> set = this.chatStateListeners;
        synchronized (set) {
            return this.chatStateListeners.add(chatStateListener);
        }
    }

    public final boolean removeChatStateListener(ChatStateListener chatStateListener) {
        Set<ChatStateListener> set = this.chatStateListeners;
        synchronized (set) {
            return this.chatStateListeners.remove(chatStateListener);
        }
    }

    public final void setCurrentState(ChatState object, Chat chat) {
        if (chat == null || object == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, (ChatState)((Object)object))) {
            return;
        }
        Message message = StanzaBuilder.buildMessage().build();
        object = new ChatStateExtension((ChatState)((Object)object));
        message.addExtension((ExtensionElement)object);
        chat.send(message);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        object = (ChatStateManager)((Object)object);
        return this.connection().equals(object.connection());
    }

    public final int hashCode() {
        return this.connection().hashCode();
    }

    private synchronized boolean updateChatState(Chat chat, ChatState chatState) {
        ChatState chatState2 = this.chatStates.get((Object)chat);
        if (chatState2 != chatState) {
            this.chatStates.put(chat, chatState);
            return true;
        }
        return false;
    }
}

