/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class OutgoingFileTransfer
extends FileTransfer {
    private static final Logger LOGGER = Logger.getLogger(OutgoingFileTransfer.class.getName());
    private static int RESPONSE_TIMEOUT = 60000;
    private NegotiationProgress callback;
    private OutputStream outputStream;
    private i initiator;
    private Thread transferThread;

    public static int getResponseTimeout() {
        return RESPONSE_TIMEOUT;
    }

    public static void setResponseTimeout(int n) {
        RESPONSE_TIMEOUT = n;
    }

    protected OutgoingFileTransfer(i i2, i i3, String string, FileTransferNegotiator fileTransferNegotiator) {
        super(i3, string, fileTransferNegotiator);
        this.initiator = i2;
    }

    protected void setOutputStream(OutputStream outputStream) {
        if (this.outputStream == null) {
            this.outputStream = outputStream;
        }
    }

    protected OutputStream getOutputStream() {
        if (this.getStatus().equals((Object)FileTransfer.Status.negotiated)) {
            return this.outputStream;
        }
        return null;
    }

    public synchronized OutputStream sendFile(String string, long l, String string2) {
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotiation process has already been attempted on this file transfer");
        }
        try {
            this.setFileInfo(string, l);
            this.outputStream = this.negotiateStream(string, l, string2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            this.handleXMPPException(xMPPErrorException);
            throw xMPPErrorException;
        }
        return this.outputStream;
    }

    public synchronized void sendFile(final String string, final long l, final String string2, final NegotiationProgress negotiationProgress) {
        if (negotiationProgress == null) {
            throw new IllegalArgumentException("Callback progress cannot be null.");
        }
        this.checkTransferThread();
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotiation process has already been attempted for this file transfer");
        }
        this.setFileInfo(string, l);
        this.callback = negotiationProgress;
        this.transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(string, l, string2);
                    negotiationProgress.outputStreamEstablished(OutgoingFileTransfer.this.outputStream);
                    return;
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException) {
                    OutgoingFileTransfer.this.handleXMPPException(xMPPErrorException);
                    return;
                }
                catch (Exception exception) {
                    OutgoingFileTransfer.this.setException(exception);
                    return;
                }
            }
        }, "File Transfer Negotiation " + this.streamID);
        this.transferThread.start();
    }

    private void checkTransferThread() {
        if (this.transferThread != null && this.transferThread.isAlive() || this.isDone()) {
            throw new IllegalStateException("File transfer in progress or has already completed.");
        }
    }

    public synchronized void sendFile(final File file, final String string) {
        this.checkTransferThread();
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Could not read file");
        }
        this.setFileInfo(file.getAbsolutePath(), file.getName(), file.length());
        this.transferThread = new Thread(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(file.getName(), file.length(), string);
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException) {
                    OutgoingFileTransfer.this.handleXMPPException(xMPPErrorException);
                    return;
                }
                catch (Exception exception) {
                    OutgoingFileTransfer.this.setException(exception);
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    OutgoingFileTransfer.this.writeToStream(fileInputStream, OutgoingFileTransfer.this.outputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    OutgoingFileTransfer.this.setException(fileNotFoundException);
                    CloseableUtil.maybeClose((Closeable)fileInputStream, (Logger)LOGGER);
                    CloseableUtil.maybeClose((Closeable)OutgoingFileTransfer.this.outputStream, (Logger)LOGGER);
                }
                catch (IOException iOException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(iOException);
                    {
                        catch (Throwable throwable) {
                            CloseableUtil.maybeClose(fileInputStream, (Logger)LOGGER);
                            CloseableUtil.maybeClose((Closeable)OutgoingFileTransfer.this.outputStream, (Logger)LOGGER);
                            throw throwable;
                        }
                    }
                    CloseableUtil.maybeClose((Closeable)fileInputStream, (Logger)LOGGER);
                    CloseableUtil.maybeClose((Closeable)OutgoingFileTransfer.this.outputStream, (Logger)LOGGER);
                }
                CloseableUtil.maybeClose((Closeable)fileInputStream, (Logger)LOGGER);
                CloseableUtil.maybeClose((Closeable)OutgoingFileTransfer.this.outputStream, (Logger)LOGGER);
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    public synchronized void sendStream(final InputStream inputStream, final String string, final long l, final String string2) {
        this.checkTransferThread();
        this.setFileInfo(string, l);
        this.transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(string, l, string2);
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException) {
                    OutgoingFileTransfer.this.handleXMPPException(xMPPErrorException);
                    return;
                }
                catch (Exception exception) {
                    OutgoingFileTransfer.this.setException(exception);
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                try {
                    OutgoingFileTransfer.this.writeToStream(inputStream, OutgoingFileTransfer.this.outputStream);
                }
                catch (IOException iOException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(iOException);
                }
                finally {
                    CloseableUtil.maybeClose((Closeable)inputStream, (Logger)LOGGER);
                    CloseableUtil.maybeClose((Closeable)OutgoingFileTransfer.this.outputStream, (Logger)LOGGER);
                }
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    public void setCallback(NegotiationProgress negotiationProgress) {
        this.callback = negotiationProgress;
    }

    private void handleXMPPException(XMPPException.XMPPErrorException xMPPErrorException) {
        StanzaError stanzaError = xMPPErrorException.getStanzaError();
        if (stanzaError != null) {
            switch (stanzaError.getCondition()) {
                case forbidden: {
                    this.setStatus(FileTransfer.Status.refused);
                    return;
                }
                case bad_request: {
                    this.setStatus(FileTransfer.Status.error);
                    this.setError(FileTransfer.Error.not_acceptable);
                    break;
                }
                default: {
                    this.setStatus(FileTransfer.Status.error);
                }
            }
        }
        this.setException((Exception)((Object)xMPPErrorException));
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    private OutputStream negotiateStream(String object, long l, String string) {
        if (!this.updateStatus(FileTransfer.Status.initial, FileTransfer.Status.negotiating_transfer)) {
            throw new SmackException.IllegalStateChangeException();
        }
        object = this.negotiator.negotiateOutgoingTransfer(this.getPeer(), this.streamID, (String)object, l, string, RESPONSE_TIMEOUT);
        if (!this.updateStatus(FileTransfer.Status.negotiating_transfer, FileTransfer.Status.negotiating_stream)) {
            throw new SmackException.IllegalStateChangeException();
        }
        this.outputStream = ((StreamNegotiator)((Object)object)).createOutgoingStream(this.streamID, this.initiator, this.getPeer());
        if (!this.updateStatus(FileTransfer.Status.negotiating_stream, FileTransfer.Status.negotiated)) {
            throw new SmackException.IllegalStateChangeException();
        }
        return this.outputStream;
    }

    @Override
    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }

    @Override
    protected boolean updateStatus(FileTransfer.Status status, FileTransfer.Status status2) {
        boolean bl = super.updateStatus(status, status2);
        if (this.callback != null && bl) {
            this.callback.statusUpdated(status, status2);
        }
        return bl;
    }

    @Override
    protected void setStatus(FileTransfer.Status status) {
        FileTransfer.Status status2 = this.getStatus();
        super.setStatus(status);
        if (this.callback != null) {
            this.callback.statusUpdated(status2, status);
        }
    }

    @Override
    protected void setException(Exception exception) {
        super.setException(exception);
        if (this.callback != null) {
            this.callback.errorEstablishingStream(exception);
        }
    }

    public static interface NegotiationProgress {
        public void statusUpdated(FileTransfer.Status var1, FileTransfer.Status var2);

        public void outputStreamEstablished(OutputStream var1);

        public void errorEstablishingStream(Exception var1);
    }
}

