/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;

public class OfflineMessageRequest
extends IQ {
    public static final String ELEMENT = "offline";
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private final List<Item> items = new ArrayList<Item>();
    private boolean purge = false;
    private boolean fetch = false;

    public OfflineMessageRequest() {
        super(ELEMENT, NAMESPACE);
    }

    public List<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items));
        }
    }

    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
            return;
        }
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean bl) {
        this.purge = bl;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean bl) {
        this.fetch = bl;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.rightAngleBracket();
        List<Item> list = this.items;
        synchronized (list) {
            for (Item item : this.items) {
                iQChildElementXmlStringBuilder.append((CharSequence)item.toXML());
            }
        }
        if (this.purge) {
            iQChildElementXmlStringBuilder.append((CharSequence)"<purge/>");
        }
        if (this.fetch) {
            iQChildElementXmlStringBuilder.append((CharSequence)"<fetch/>");
        }
        return iQChildElementXmlStringBuilder;
    }

    public static class Provider
    extends IQProvider<OfflineMessageRequest> {
        public OfflineMessageRequest parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
            OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
            boolean bl = false;
            while (!bl) {
                XmlPullParser.Event event = xmlPullParser.next();
                if (event == XmlPullParser.Event.START_ELEMENT) {
                    if (xmlPullParser.getName().equals("item")) {
                        offlineMessageRequest.addItem(Provider.parseItem(xmlPullParser));
                        continue;
                    }
                    if (xmlPullParser.getName().equals("purge")) {
                        offlineMessageRequest.setPurge(true);
                        continue;
                    }
                    if (!xmlPullParser.getName().equals("fetch")) continue;
                    offlineMessageRequest.setFetch(true);
                    continue;
                }
                if (event != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals(OfflineMessageRequest.ELEMENT)) continue;
                bl = true;
            }
            return offlineMessageRequest;
        }

        private static Item parseItem(XmlPullParser xmlPullParser) {
            boolean bl = false;
            Item item = new Item(xmlPullParser.getAttributeValue("", "node"));
            item.setAction(xmlPullParser.getAttributeValue("", "action"));
            item.setJid(xmlPullParser.getAttributeValue("", "jid"));
            while (!bl) {
                XmlPullParser.Event event = xmlPullParser.next();
                if (event != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("item")) continue;
                bl = true;
            }
            return item;
        }
    }

    public static class Item {
        private String action;
        private String jid;
        private String node;

        public Item(String string) {
            this.node = string;
        }

        public String getNode() {
            return this.node;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String string) {
            this.action = string;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String string) {
            this.jid = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item");
            if (this.getAction() != null) {
                stringBuilder.append(" action=\"").append(this.getAction()).append('\"');
            }
            if (this.getJid() != null) {
                stringBuilder.append(" jid=\"").append(this.getJid()).append('\"');
            }
            if (this.getNode() != null) {
                stringBuilder.append(" node=\"").append(this.getNode()).append('\"');
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

