/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextInclusionStrategy;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u0002092\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010D\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010E\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010F\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0015\u0010G\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0015\u0010J\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bKJ\u0012\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010N\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010O\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010P\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0018\u0010Q\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00052\u0006\u0010R\u001a\u000202H\u0016J\u0010\u0010S\u001a\u0002022\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010T\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020$H\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010M2\u0006\u0010V\u001a\u00020$H\u0002J\u0018\u0010X\u001a\u00020$2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010Y\u001a\u000202H\u0016J\u0010\u0010Z\u001a\u00020$2\u0006\u0010[\u001a\u000202H\u0002J\u0013\u0010b\u001a\b\u0012\u0004\u0012\u00020M0]H\u0002\u00a2\u0006\u0002\u0010aJ\u0012\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u001c\u0010e\u001a\u0004\u0018\u00010d2\u0006\u0010A\u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020\u0005H\u0002J\u0010\u0010f\u001a\u00020g2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010h\u001a\u00020g2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0017\u0010i\u001a\u00020\u00052\u0006\u0010j\u001a\u00020kH\u0016\u00a2\u0006\u0004\bl\u0010mJ'\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u0002092\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tH\u0016\u00a2\u0006\u0004\bu\u0010vJ\u0010\u0010w\u001a\u0002092\u0006\u0010A\u001a\u00020\u0005H\u0016J'\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020o2\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b~\u0010\u007fJ\u001a\u0010\u0080\u0001\u001a\u00020o2\u0006\u0010A\u001a\u00020\u0005H\u0016\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001J>\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001JT\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0017\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J]\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020$2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0017\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u0012\u0010\u0099\u0001\u001a\u00020y2\u0006\u0010A\u001a\u00020\u0005H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010&R\u0014\u0010-\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010&R\u0014\u0010/\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010&R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u001c\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u000109088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0018\u0010\\\u001a\n\u0012\u0004\u0012\u00020M\u0018\u00010]X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010^R\u001a\u0010_\u001a\b\u0012\u0004\u0012\u00020M0]8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010a\u00a8\u0006\u009a\u0001"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "maxLines", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "<init>", "(Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;IIJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getMaxLines", "()I", "I", "getConstraints-msEJaDk", "()J", "J", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$ui_text", "()Lorg/jetbrains/skia/Font;", "value", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraph", "setParagraph", "(Lorg/jetbrains/skia/paragraph/Paragraph;)V", "ellipsis", "", "getEllipsis", "()Ljava/lang/String;", "text", "getText", "width", "", "getWidth", "()F", "height", "getHeight", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "firstBaseline", "getFirstBaseline", "lastBaseline", "getLastBaseline", "didExceedMaxLines", "", "getDidExceedMaxLines", "()Z", "lineCount", "getLineCount", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getCursorRect", "offset", "getLineLeft", "lineIndex", "getLineRight", "getLineTop", "getLineBottom", "getLineAscent", "getLineAscent$ui_text", "getLineBaseline", "getLineDescent", "getLineDescent$ui_text", "lineMetricsForOffset", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineHeight", "getLineWidth", "getLineStart", "getLineEnd", "visibleEnd", "isLineEllipsized", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineMetricsForVerticalPosition", "getHorizontalPosition", "usePrimaryDirection", "getAlignedStartingPosition", "isRtl", "_lineMetrics", "", "[Lorg/jetbrains/skia/paragraph/LineMetrics;", "lineMetrics", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "receiveLineMetrics", "getBoxForwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "getBoxBackwardByOffset", "getParagraphDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBidiRunDirection", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getRangeForRect", "Landroidx/compose/ui/text/TextRange;", "rect", "granularity", "Landroidx/compose/ui/text/TextGranularity;", "inclusionStrategy", "Landroidx/compose/ui/text/TextInclusionStrategy;", "getRangeForRect-8-6BmAI", "(Landroidx/compose/ui/geometry/Rect;ILandroidx/compose/ui/text/TextInclusionStrategy;)J", "getBoundingBox", "fillBoundingBoxes", "", "range", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getWordBoundary", "getWordBoundary--jx7JFs", "(I)J", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "checkOffsetIsValid", "ui-text"})
public final class SkiaParagraph
implements Paragraph {
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final int overflow;
    private final long constraints;
    private final ParagraphLayouter layouter;
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    private LineMetrics[] _lineMetrics;
    public static final int $stable = 8;

    private SkiaParagraph(SkiaParagraphIntrinsics object, int n, int n2, long l) {
        int n3;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.paragraphIntrinsics = object;
        this.maxLines = n;
        this.overflow = n2;
        this.constraints = l;
        SkiaParagraph skiaParagraph = this;
        object = skiaParagraph.paragraphIntrinsics.layouter();
        ParagraphLayouter paragraphLayouter = object;
        SkiaParagraph skiaParagraph2 = skiaParagraph;
        paragraphLayouter.setParagraphStyle(this.maxLines, this.getEllipsis());
        skiaParagraph2.layouter = object;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        boolean bl = Constraints.getMinHeight-impl((long)this.constraints) == 0 && Constraints.getMinWidth-impl((long)this.constraints) == 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("Setting Constraints.minWidth and Constraints.minHeight is not supported, these should be the default zero values instead.");
        }
        if (!(bl = this.maxLines > 0)) {
            InlineClassHelperKt.throwIllegalArgumentException("maxLines should be greater than 0");
        }
        float f = this.getWidth();
        float f2 = this.getHeight();
        long l2 = Float.floatToRawIntBits(f);
        long l3 = Float.floatToRawIntBits(f2);
        this.layouter.setBrushSize-uvyYCjk(Size.constructor-impl((long)(l2 << 32 | l3 & 0xFFFFFFFFL)));
        SkiaParagraph skiaParagraph3 = this;
        skiaParagraph3.setParagraph(skiaParagraph3.layouter.layoutParagraph(this.getWidth()));
        if (TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8()) && this.paragraph.getHeight() > (float)Constraints.getMaxHeight-impl((long)this.constraints) && this.maxLines > 1 && (n3 = SkiaParagraph_skikoKt.access$numberOfLinesThatFitMaxHeight(this, Constraints.getMaxHeight-impl((long)this.constraints))) >= 0 && n3 != this.maxLines) {
            this.layouter.setParagraphStyle(RangesKt.coerceAtLeast((int)n3, (int)1), this.getEllipsis());
            SkiaParagraph skiaParagraph4 = this;
            skiaParagraph4.setParagraph(skiaParagraph4.layouter.layoutParagraph(this.getWidth()));
        }
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    public final Font getDefaultFont$ui_text() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph paragraph) {
        this.paragraph = paragraph;
        this._lineMetrics = null;
    }

    private final String getEllipsis() {
        Object[] objectArray = new TextOverflow[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = TextOverflow.box-impl(TextOverflow.Companion.getEllipsis-gIe3tQ8());
        objectArray2[1] = TextOverflow.box-impl(TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8());
        objectArray2[2] = TextOverflow.box-impl(TextOverflow.Companion.getStartEllipsis-gIe3tQ8());
        if (CollectionsKt.listOf((Object[])objectArray2).contains(TextOverflow.box-impl(this.overflow))) {
            return "\u2026";
        }
        return "";
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public final float getWidth() {
        return Constraints.getMaxWidth-impl((long)this.constraints);
    }

    @Override
    public final float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public final float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public final float getFirstBaseline() {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            return (float)lineMetrics.getBaseline();
        }
        return 0.0f;
    }

    @Override
    public final float getLastBaseline() {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            return (float)lineMetrics.getBaseline();
        }
        return 0.0f;
    }

    @Override
    public final boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public final int getLineCount() {
        if (Intrinsics.areEqual((Object)this.getText(), (Object)"") || this.paragraph.getLineNumber() <= 0) {
            return 1;
        }
        return this.paragraph.getLineNumber();
    }

    @Override
    public final List<Rect> getPlaceholderRects() {
        Object object = this.paragraph.getRectsForPlaceholders();
        TextBox[] textBoxArray = object;
        object = new ArrayList(((TextBox[])object).length);
        for (TextBox textBox : textBoxArray) {
            Object object2 = object;
            object2.add(Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)textBox.getRect()));
        }
        return (List)object;
    }

    @Override
    public final androidx.compose.ui.graphics.Path getPathForRange(int n, int n2) {
        boolean bl = (n >= 0 ? n <= n2 : false) && n2 <= this.getText().length();
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("start(" + n + ") or end(" + n2 + ") is out of range [0.." + this.getText().length() + "], or start > end!");
        }
        TextBox[] textBoxArray = this.paragraph.getRectsForRange(n, n2, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path = SkiaBackedPath_skikoKt.Path();
        for (TextBox textBox : textBoxArray) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath((androidx.compose.ui.graphics.Path)path), (org.jetbrains.skia.Rect)textBox.getRect(), null, (int)0, (int)6, null);
        }
        return path;
    }

    @Override
    public final Rect getCursorRect(int n) {
        double d;
        double d2;
        boolean bl;
        SkiaParagraph skiaParagraph = this;
        boolean bl2 = n >= 0 ? n <= skiaParagraph.getText().length() : (bl = false);
        if (!bl2) {
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n + ") is out of bounds [0," + skiaParagraph.getText().length() + "]");
        }
        float f = this.getHorizontalPosition(n, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(n);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics lineMetrics2 = lineMetrics;
        bl = n - 1 == lineMetrics2.getStartIndex() && n == this.getText().length();
        FontMetrics fontMetrics = this.getDefaultFont$ui_text().getMetrics();
        double d3 = lineMetrics2.getAscent();
        if (bl) {
            double d4 = -((double)fontMetrics.getAscent());
            d2 = RangesKt.coerceAtMost((double)d3, (double)d4);
        } else {
            d2 = d3;
        }
        double d5 = d2;
        double d6 = lineMetrics2.getDescent();
        if (bl) {
            double d7 = fontMetrics.getDescent();
            d = RangesKt.coerceAtMost((double)d6, (double)d7);
        } else {
            d = d6;
        }
        double d8 = d;
        return new Rect(f, (float)(lineMetrics2.getBaseline() - d5), f, (float)(lineMetrics2.getBaseline() + d8));
    }

    @Override
    public final float getLineLeft(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return (float)lineMetrics.getLeft();
        }
        return 0.0f;
    }

    @Override
    public final float getLineRight(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return (float)lineMetrics.getRight();
        }
        return 0.0f;
    }

    @Override
    public final float getLineTop(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            return (float)Math.floor((float)(lineMetrics.getBaseline() - lineMetrics2.getAscent()));
        }
        return 0.0f;
    }

    @Override
    public final float getLineBottom(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            return (float)Math.floor((float)(lineMetrics.getBaseline() + lineMetrics2.getDescent()));
        }
        return 0.0f;
    }

    public final float getLineAscent$ui_text(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return -(lineMetrics != null ? (float)lineMetrics.getAscent() : 0.0f);
    }

    @Override
    public final float getLineBaseline(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return (float)lineMetrics.getBaseline();
        }
        return 0.0f;
    }

    public final float getLineDescent$ui_text(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return (float)lineMetrics.getDescent();
        }
        return 0.0f;
    }

    private final LineMetrics lineMetricsForOffset(int n) {
        Object[] objectArray;
        boolean bl = n >= 0 ? n <= this.getText().length() : false;
        if (bl && !((objectArray = this.getLineMetrics()).length == 0)) {
            n = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])objectArray), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(n){
                final /* synthetic */ int $offset$inlined;
                {
                    this.$offset$inlined = n;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object object) {
                    return this.$offset$inlined < (object = (LineMetrics)object).getEndIncludingNewline() ? 1 : -1;
                }
            }), (int)3, null);
            return objectArray[RangesKt.coerceAtMost((int)(-n - 1), (int)ArraysKt.getLastIndex((Object[])objectArray))];
        }
        return null;
    }

    @Override
    public final float getLineHeight(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return (float)lineMetrics.getHeight();
        }
        return 0.0f;
    }

    @Override
    public final float getLineWidth(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return (float)lineMetrics.getWidth();
        }
        return 0.0f;
    }

    @Override
    public final int getLineStart(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            return lineMetrics.getStartIndex();
        }
        return 0;
    }

    @Override
    public final int getLineEnd(int n, boolean bl) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics lineMetrics2 = lineMetrics;
        if (bl && (n <= 0 || lineMetrics2.getStartIndex() >= this.getLineMetrics()[n - 1].getEndIndex())) {
            if (lineMetrics2.getStartIndex() < this.getText().length() && this.getText().charAt(lineMetrics2.getStartIndex()) == '\n') {
                return lineMetrics2.getStartIndex();
            }
            return lineMetrics2.getEndExcludingWhitespaces();
        }
        return lineMetrics2.getEndIndex();
    }

    @Override
    public final boolean isLineEllipsized(int n) {
        return false;
    }

    @Override
    public final int getLineForOffset(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > this.getText().length()) {
            return this.getLineCount() - 1;
        }
        LineMetrics lineMetrics = this.lineMetricsForOffset(n);
        Intrinsics.checkNotNull((Object)lineMetrics);
        return lineMetrics.getLineNumber();
    }

    @Override
    public final int getLineForVerticalPosition(float f) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(f);
        if (lineMetrics != null) {
            return lineMetrics.getLineNumber();
        }
        return 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float f) {
        Object[] objectArray = this.getLineMetrics();
        if (objectArray.length == 0) {
            return null;
        }
        int n = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])objectArray), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(f){
            final /* synthetic */ float $vertical$inlined;
            {
                this.$vertical$inlined = f;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object object) {
                return (double)this.$vertical$inlined < (object = (LineMetrics)object).getBaseline() + object.getDescent() ? 1 : -1;
            }
        }), (int)3, null);
        return objectArray[RangesKt.coerceAtMost((int)(-n - 1), (int)ArraysKt.getLastIndex((Object[])objectArray))];
    }

    @Override
    public final float getHorizontalPosition(int n, boolean bl) {
        boolean bl2;
        TextBox textBox = SkiaParagraph.getBoxBackwardByOffset$default(this, n, 0, 2, null);
        TextBox textBox2 = this.getBoxForwardByOffset(n);
        boolean bl3 = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean bl4 = bl2 = !bl3;
        if (textBox == null && textBox2 == null) {
            return this.getAlignedStartingPosition(bl3);
        }
        if (textBox == null) {
            TextBox textBox3 = textBox2;
            Intrinsics.checkNotNull((Object)textBox3);
            return androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox3, true);
        }
        if (textBox2 == null) {
            return androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(textBox, false, 1, null);
        }
        if (!(textBox2.getDirection() == textBox.getDirection() || bl2 && textBox.getDirection() == Direction.LTR || bl3 && textBox.getDirection() == Direction.RTL || !bl)) {
            return androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(textBox, false, 1, null);
        }
        return androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox2, true);
    }

    private final float getAlignedStartingPosition(boolean bl) {
        int n = this.layouter.getTextStyle().getTextAlign-e0LSkKk();
        if (!TextAlign.equals-impl0(n, TextAlign.Companion.getLeft-e0LSkKk())) {
            if (TextAlign.equals-impl0(n, TextAlign.Companion.getRight-e0LSkKk())) {
                return this.getWidth();
            }
            if (TextAlign.equals-impl0(n, TextAlign.Companion.getCenter-e0LSkKk())) {
                return this.getWidth() / 2.0f;
            }
            if (TextAlign.equals-impl0(n, TextAlign.Companion.getStart-e0LSkKk())) {
                if (bl) {
                    return this.getWidth();
                }
                return 0.0f;
            }
            if (TextAlign.equals-impl0(n, TextAlign.Companion.getEnd-e0LSkKk()) && !bl) {
                return this.getWidth();
            }
        }
        return 0.0f;
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray;
        LineMetrics[] lineMetricsArray2 = this._lineMetrics;
        if (this._lineMetrics == null) {
            lineMetricsArray = this.receiveLineMetrics();
            LineMetrics[] lineMetricsArray3 = lineMetricsArray;
            this._lineMetrics = lineMetricsArray3;
            lineMetricsArray2 = lineMetricsArray;
        }
        lineMetricsArray = lineMetricsArray2;
        return lineMetricsArray2;
    }

    private final LineMetrics[] receiveLineMetrics() {
        LineMetrics[] lineMetricsArray = ((CharSequence)this.getText()).length() == 0 ? this.layouter.emptyLineMetrics$ui_text(this.paragraph) : this.paragraph.getLineMetrics();
        FontMetrics fontMetrics = this.getDefaultFont$ui_text().getMetrics();
        if (!(lineMetricsArray.length == 0)) {
            lineMetricsArray[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetricsArray[0], fontMetrics, this.layouter.getTextStyle());
            lineMetricsArray[lineMetricsArray.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetricsArray[lineMetricsArray.length - 1], fontMetrics, this.layouter.getTextStyle());
        }
        return lineMetricsArray;
    }

    private final TextBox getBoxForwardByOffset(int n) {
        if (!(n >= 0 ? n <= this.getText().length() : false)) {
            return null;
        }
        for (int k = n + 1; k <= this.getText().length(); ++k) {
            TextBox textBox = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(n, k, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (textBox == null) continue;
            return textBox;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int n, int n2) {
        boolean bl;
        if (!(n >= 0 ? n <= this.getText().length() : false)) {
            return null;
        }
        boolean bl2 = bl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int k = n - 1; k >= 0; --k) {
            TextBox textBox = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(k, n2, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (textBox == null) {
                continue;
            }
            if (this.getText().charAt(k) == '\n') {
                if (!bl) {
                    float f = textBox.getRect().getBottom() + textBox.getRect().getBottom() - textBox.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, textBox.getRect().getBottom(), 0.0f, f);
                    return new TextBox(rect, textBox.getDirection());
                }
                if (k == StringsKt.getLastIndex((CharSequence)this.getText())) {
                    float f = textBox.getRect().getBottom() + textBox.getRect().getBottom() - textBox.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(this.getWidth(), textBox.getRect().getBottom(), this.getWidth(), f);
                    return new TextBox(rect, textBox.getDirection());
                }
                int n3 = n;
                TextBox textBox2 = (TextBox)ArraysKt.first((Object[])this.paragraph.getRectsForRange(n3, n3 + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(textBox2.getRect().getLeft(), textBox2.getRect().getTop(), textBox2.getRect().getLeft(), textBox2.getRect().getBottom());
                return new TextBox(rect, textBox2.getDirection());
            }
            return textBox;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    public final ResolvedTextDirection getParagraphDirection(int n) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    public final ResolvedTextDirection getBidiRunDirection(int n) {
        TextBox textBox = this.getBoxForwardByOffset(n);
        Object object = textBox != null ? textBox.getDirection() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                return ResolvedTextDirection.Rtl;
            }
            case 2: {
                return ResolvedTextDirection.Ltr;
            }
            case -1: {
                return ResolvedTextDirection.Ltr;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public final int getOffsetForPosition-k-4lQ0M(long l) {
        int n;
        boolean bl;
        float f;
        int n2;
        int n3;
        boolean bl2;
        int n4 = (int)(l >> 32);
        int n5 = n4;
        n5 = (int)l;
        int n6 = n5 = this.paragraph.getGlyphPositionAtCoordinate(Float.intBitsToFloat(n4), Float.intBitsToFloat(n5)).getPosition();
        boolean bl3 = n5 >= 0 ? n5 < this.getText().length() : false;
        if (bl3 && (bl2 = CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), n5)))) {
            n3 = CharHelpers_skikoKt.findPrecedingBreak(this.getText(), n5);
            int n7 = CharHelpers_skikoKt.findFollowingBreak(this.getText(), n5);
            if (n3 != n5 && n7 != n5) {
                n6 = n7;
            }
        }
        int n8 = (int)l;
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Float.intBitsToFloat(n8));
        if (lineMetrics == null) {
            return n6;
        }
        LineMetrics lineMetrics2 = lineMetrics;
        n3 = lineMetrics.getStartIndex() < lineMetrics2.getEndIndex() ? 1 : 0;
        n8 = (int)(l >> 32);
        if ((double)Float.intBitsToFloat(n2) > lineMetrics2.getLeft() && (double)Float.intBitsToFloat(n8) < lineMetrics2.getRight()) {
            return n6;
        }
        TextBox textBox = n3 != 0 ? this.paragraph.getRectsForRange(lineMetrics2.getStartIndex(), lineMetrics2.isHardBreak() ? lineMetrics2.getEndIndex() : lineMetrics2.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null;
        TextBox textBox2 = textBox;
        float f2 = textBox != null && (textBox2 = (TextBox[])ArraysKt.firstOrNull(textBox2)) != null && (textBox2 = textBox2.getRect()) != null ? textBox2.getLeft() : (float)lineMetrics2.getLeft();
        TextBox textBox3 = textBox;
        float f3 = f = textBox3 != null && (textBox3 = (TextBox)ArraysKt.lastOrNull((Object[])textBox3)) != null && (textBox3 = textBox3.getRect()) != null ? textBox3.getRight() : (float)lineMetrics2.getRight();
        if (f2 == f) {
            return n6;
        }
        boolean bl4 = n3 != 0 && lineMetrics2.getEndExcludingWhitespaces() > 0 ? ((n8 = lineMetrics2.getEndExcludingWhitespaces() - 1) >= 0 && n8 < this.getText().length() ? CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), n8)) : false) : (bl = false);
        if (bl4) {
            return n6;
        }
        n8 = n6;
        n6 = (int)(l >> 32);
        if (Float.intBitsToFloat(n) <= f2) {
            n6 = (int)l;
            n8 = this.paragraph.getGlyphPositionAtCoordinate(f2 + 1.0f, Float.intBitsToFloat(n6)).getPosition();
        } else if (Float.intBitsToFloat(n6) >= f) {
            n6 = (int)l;
            n8 = this.paragraph.getGlyphPositionAtCoordinate(f - 1.0f, Float.intBitsToFloat(n6)).getPosition();
            boolean bl5 = (n8 >= 0 ? n8 < ((CharSequence)this.getText()).length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), n8)) : false;
            if (!bl5) {
                TextBox textBox4 = SkiaParagraph.getBoxBackwardByOffset$default(this, n8, 0, 2, null);
                if ((textBox4 != null ? textBox4.getDirection() : null) == Direction.RTL) {
                    --n8;
                }
            }
        }
        return n8;
    }

    @Override
    public final long getRangeForRect-8-6BmAI(Rect rect, int n, TextInclusionStrategy textInclusionStrategy) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        Intrinsics.checkNotNullParameter((Object)textInclusionStrategy, (String)"");
        return TextRange.Companion.getZero-d9O1mEE();
    }

    @Override
    public final Rect getBoundingBox(int n) {
        TextBox textBox;
        boolean bl;
        boolean bl2 = n >= 0 ? n < ((CharSequence)this.getText()).length() : (bl = false);
        if (!bl2) {
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n + ") is out of bounds [0," + this.getText().length() + ")");
        }
        if ((textBox = this.getBoxForwardByOffset(n)) == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(n, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull((Object)textBox2);
        }
        TextBox textBox3 = textBox;
        return Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)textBox.getRect());
    }

    @Override
    public final void fillBoundingBoxes-8ffj60Q(long l, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        System.out.println((Object)"Compose Multiplatform doesn't support fillBoundingBoxes` yet. Follow https://youtrack.jetbrains.com/issue/CMP-720");
    }

    @Override
    public final long getWordBoundary--jx7JFs(int n) {
        boolean bl;
        SkiaParagraph skiaParagraph = this;
        boolean bl2 = n >= 0 ? n <= skiaParagraph.getText().length() : (bl = false);
        if (!bl2) {
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n + ") is out of bounds [0," + skiaParagraph.getText().length() + "]");
        }
        if (n < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(n)) || n == this.getText().length()) {
            if (n > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(n - 1))) {
                return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(n - 1));
            }
            int n2 = n;
            return TextRangeKt.TextRange(n2, n2);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(n));
    }

    @Override
    public final void paint-RPmYEkk(Canvas canvas, long l, Shadow shadow, TextDecoration textDecoration) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        SkiaParagraph skiaParagraph = this;
        ParagraphLayouter paragraphLayouter = skiaParagraph.layouter;
        SkiaParagraph skiaParagraph2 = skiaParagraph;
        paragraphLayouter.setColor-8_81llA(l);
        paragraphLayouter.setTextStyle(shadow, textDecoration);
        skiaParagraph2.setParagraph(paragraphLayouter.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    @Override
    public final void paint-LG529CI(Canvas canvas, long l, Shadow shadow, TextDecoration textDecoration, DrawStyle drawStyle, int n) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        SkiaParagraph skiaParagraph = this;
        ParagraphLayouter paragraphLayouter = skiaParagraph.layouter;
        SkiaParagraph skiaParagraph2 = skiaParagraph;
        paragraphLayouter.setColor-8_81llA(l);
        paragraphLayouter.setTextStyle(shadow, textDecoration);
        paragraphLayouter.setDrawStyle(drawStyle);
        paragraphLayouter.setBlendMode-s9anfk8(n);
        skiaParagraph2.setParagraph(paragraphLayouter.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    @Override
    public final void paint-hn5TExg(Canvas canvas, Brush brush, float f, Shadow shadow, TextDecoration textDecoration, DrawStyle drawStyle, int n) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"");
        SkiaParagraph skiaParagraph = this;
        ParagraphLayouter paragraphLayouter = skiaParagraph.layouter;
        SkiaParagraph skiaParagraph2 = skiaParagraph;
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        long l = Float.floatToRawIntBits(f2);
        long l2 = Float.floatToRawIntBits(f3);
        paragraphLayouter.setBrush-12SF9DM(brush, Size.constructor-impl((long)(l << 32 | l2 & 0xFFFFFFFFL)), f);
        paragraphLayouter.setTextStyle(shadow, textDecoration);
        paragraphLayouter.setDrawStyle(drawStyle);
        paragraphLayouter.setBlendMode-s9anfk8(n);
        skiaParagraph2.setParagraph(paragraphLayouter.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int n) {
        boolean bl;
        boolean bl2 = n >= 0 ? n <= this.getText().length() : (bl = false);
        if (!bl2) {
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n + ") is out of bounds [0," + this.getText().length() + "]");
        }
    }

    public /* synthetic */ SkiaParagraph(SkiaParagraphIntrinsics skiaParagraphIntrinsics, int n, int n2, long l, DefaultConstructorMarker defaultConstructorMarker) {
        this(skiaParagraphIntrinsics, n, n2, l);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

