/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorTypeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0086\u0081\u0002\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001aR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006j\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3\u00a8\u00065"}, d2={"Lorg/jetbrains/skia/ColorType;", "", "(Ljava/lang/String;I)V", "bytesPerPixel", "", "getBytesPerPixel", "()I", "isAlwaysOpaque", "", "()Z", "shiftPerPixel", "getShiftPerPixel", "computeOffset", "", "x", "y", "rowBytes", "getA", "", "color", "", "", "getB", "getG", "getR", "validateAlphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "alphaType", "UNKNOWN", "ALPHA_8", "RGB_565", "ARGB_4444", "RGBA_8888", "RGB_888X", "BGRA_8888", "RGBA_1010102", "BGRA_1010102", "RGB_101010X", "BGR_101010X", "BGR_101010X_XR", "BGRA_10101010_XR", "RGBA_10x6", "GRAY_8", "RGBA_F16NORM", "RGBA_F16", "RGBA_F32", "R8G8_UNORM", "A16_FLOAT", "R16G16_FLOAT", "A16_UNORM", "R16G16_UNORM", "R16G16B16A16_UNORM", "Companion", "skiko"})
public final class ColorType
extends Enum<ColorType> {
    public static final Companion Companion;
    private static ColorType N32;
    public static final /* enum */ ColorType UNKNOWN;
    public static final /* enum */ ColorType ALPHA_8;
    public static final /* enum */ ColorType RGB_565;
    public static final /* enum */ ColorType ARGB_4444;
    public static final /* enum */ ColorType RGBA_8888;
    public static final /* enum */ ColorType RGB_888X;
    public static final /* enum */ ColorType BGRA_8888;
    public static final /* enum */ ColorType RGBA_1010102;
    public static final /* enum */ ColorType BGRA_1010102;
    public static final /* enum */ ColorType RGB_101010X;
    public static final /* enum */ ColorType BGR_101010X;
    public static final /* enum */ ColorType BGR_101010X_XR;
    public static final /* enum */ ColorType BGRA_10101010_XR;
    public static final /* enum */ ColorType RGBA_10x6;
    public static final /* enum */ ColorType GRAY_8;
    public static final /* enum */ ColorType RGBA_F16NORM;
    public static final /* enum */ ColorType RGBA_F16;
    public static final /* enum */ ColorType RGBA_F32;
    public static final /* enum */ ColorType R8G8_UNORM;
    public static final /* enum */ ColorType A16_FLOAT;
    public static final /* enum */ ColorType R16G16_FLOAT;
    public static final /* enum */ ColorType A16_UNORM;
    public static final /* enum */ ColorType R16G16_UNORM;
    public static final /* enum */ ColorType R16G16B16A16_UNORM;
    private static final /* synthetic */ ColorType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public final int getBytesPerPixel() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 8;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 8;
            }
            case 17: {
                return 8;
            }
            case 18: {
                return 16;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 2;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 2;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 8;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final int getShiftPerPixel() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 0;
            }
            case 16: {
                return 3;
            }
            case 17: {
                return 3;
            }
            case 18: {
                return 4;
            }
            case 19: {
                return 1;
            }
            case 20: {
                return 1;
            }
            case 21: {
                return 2;
            }
            case 22: {
                return 1;
            }
            case 23: {
                return 2;
            }
            case 24: {
                return 3;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final ColorAlphaType validateAlphaType(ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                return ColorAlphaType.UNKNOWN;
            }
            case 2: 
            case 20: 
            case 22: {
                if (ColorAlphaType.UNPREMUL == colorAlphaType) {
                    return ColorAlphaType.PREMUL;
                }
                if (ColorAlphaType.UNKNOWN == colorAlphaType) {
                    return null;
                }
                return colorAlphaType;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                if (ColorAlphaType.UNKNOWN == colorAlphaType) {
                    return null;
                }
                return colorAlphaType;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 21: 
            case 23: {
                return ColorAlphaType.OPAQUE;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final long computeOffset(int n, int n2, long l) {
        if (this == UNKNOWN) {
            return 0L;
        }
        return (long)n2 * l + (long)(n << this.getShiftPerPixel());
    }

    public final float getR(byte by) {
        if (WhenMappings.$EnumSwitchMapping$0[this.ordinal()] == 15) {
            return (float)(by & 0xFF) / 255.0f;
        }
        throw new IllegalArgumentException("getR(byte) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getR(short s) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 3: {
                return (float)(s >> 11 & 0x1F) / 31.0f;
            }
            case 4: {
                return (float)(s >> 8 & 0xF) / 15.0f;
            }
        }
        throw new IllegalArgumentException("getR(short) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getR(int n) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 5: {
                return (float)(n >>> 24) / 255.0f;
            }
            case 7: {
                return (float)(n >>> 24) / 255.0f;
            }
            case 6: {
                return (float)(n >> 8 & 0xFF) / 255.0f;
            }
            case 8: {
                return (float)(n >> 22 & 0x3FF) / 1023.0f;
            }
            case 9: {
                return (float)(n >> 22 & 0x3FF) / 1023.0f;
            }
            case 10: {
                return (float)(n >> 2 & 0x3FF) / 1023.0f;
            }
            case 11: {
                return (float)(n >> 2 & 0x3FF) / 1023.0f;
            }
        }
        throw new IllegalArgumentException("getR(int) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getG(byte by) {
        if (WhenMappings.$EnumSwitchMapping$0[this.ordinal()] == 15) {
            return (float)(by & 0xFF) / 255.0f;
        }
        throw new IllegalArgumentException("getG(byte) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getG(short s) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 3: {
                return (float)(s >> 5 & 0x3F) / 63.0f;
            }
            case 4: {
                return (float)(s >> 4 & 0xF) / 15.0f;
            }
        }
        throw new IllegalArgumentException("getG(short) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getG(int n) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 5: {
                return (float)(n >> 16 & 0xFF) / 255.0f;
            }
            case 7: {
                return (float)(n >> 16 & 0xFF) / 255.0f;
            }
            case 6: {
                return (float)(n >> 16 & 0xFF) / 255.0f;
            }
            case 8: {
                return (float)(n >> 12 & 0x3FF) / 1023.0f;
            }
            case 9: {
                return (float)(n >> 12 & 0x3FF) / 1023.0f;
            }
            case 10: {
                return (float)(n >> 12 & 0x3FF) / 1023.0f;
            }
            case 11: {
                return (float)(n >> 12 & 0x3FF) / 1023.0f;
            }
        }
        throw new IllegalArgumentException("getG(int) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getB(byte by) {
        if (WhenMappings.$EnumSwitchMapping$0[this.ordinal()] == 15) {
            return (float)(by & 0xFF) / 255.0f;
        }
        throw new IllegalArgumentException("getB(byte) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getB(short s) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 3: {
                return (float)(s & 0x1F) / 31.0f;
            }
            case 4: {
                return (float)(s & 0xF) / 15.0f;
            }
        }
        throw new IllegalArgumentException("getB(short) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getB(int n) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 5: {
                return (float)(n >> 8 & 0xFF) / 255.0f;
            }
            case 7: {
                return (float)(n >> 8 & 0xFF) / 255.0f;
            }
            case 6: {
                return (float)(n >>> 24) / 255.0f;
            }
            case 8: {
                return (float)(n >> 2 & 0x3FF) / 1023.0f;
            }
            case 9: {
                return (float)(n >> 2 & 0x3FF) / 1023.0f;
            }
            case 10: {
                return (float)(n >> 22 & 0x3FF) / 1023.0f;
            }
            case 11: {
                return (float)(n >> 22 & 0x3FF) / 1023.0f;
            }
        }
        throw new IllegalArgumentException("getB(int) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getA(byte by) {
        if (WhenMappings.$EnumSwitchMapping$0[this.ordinal()] == 2) {
            return (float)(by & 0xFF) / 255.0f;
        }
        throw new IllegalArgumentException("getA(byte) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getA(short s) {
        if (WhenMappings.$EnumSwitchMapping$0[this.ordinal()] == 4) {
            return (float)(s >> 12 & 0xF) / 15.0f;
        }
        throw new IllegalArgumentException("getA(short) is not supported on ColorType." + (Object)((Object)this));
    }

    public final float getA(int n) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 5: {
                return (float)(n & 0xFF) / 255.0f;
            }
            case 6: {
                return (float)(n & 0xFF) / 255.0f;
            }
            case 8: {
                return (float)(n & 3) / 3.0f;
            }
            case 10: {
                return (float)(n & 3) / 3.0f;
            }
        }
        throw new IllegalArgumentException("getA(int) is not supported on ColorType." + (Object)((Object)this));
    }

    public final boolean isAlwaysOpaque() {
        return ColorTypeKt.access$_nIsAlwaysOpaque(this.ordinal());
    }

    public static ColorType[] values() {
        return (ColorType[])$VALUES.clone();
    }

    public static ColorType valueOf(String string) {
        return Enum.valueOf(ColorType.class, string);
    }

    public static EnumEntries<ColorType> getEntries() {
        return $ENTRIES;
    }

    private static final /* synthetic */ ColorType[] $values() {
        ColorType[] colorTypeArray = new ColorType[24];
        ColorType[] colorTypeArray2 = colorTypeArray;
        colorTypeArray[0] = UNKNOWN;
        colorTypeArray2[1] = ALPHA_8;
        colorTypeArray2[2] = RGB_565;
        colorTypeArray2[3] = ARGB_4444;
        colorTypeArray2[4] = RGBA_8888;
        colorTypeArray2[5] = RGB_888X;
        colorTypeArray2[6] = BGRA_8888;
        colorTypeArray2[7] = RGBA_1010102;
        colorTypeArray2[8] = BGRA_1010102;
        colorTypeArray2[9] = RGB_101010X;
        colorTypeArray2[10] = BGR_101010X;
        colorTypeArray2[11] = BGR_101010X_XR;
        colorTypeArray2[12] = BGRA_10101010_XR;
        colorTypeArray2[13] = RGBA_10x6;
        colorTypeArray2[14] = GRAY_8;
        colorTypeArray2[15] = RGBA_F16NORM;
        colorTypeArray2[16] = RGBA_F16;
        colorTypeArray2[17] = RGBA_F32;
        colorTypeArray2[18] = R8G8_UNORM;
        colorTypeArray2[19] = A16_FLOAT;
        colorTypeArray2[20] = R16G16_FLOAT;
        colorTypeArray2[21] = A16_UNORM;
        colorTypeArray2[22] = R16G16_UNORM;
        colorTypeArray2[23] = R16G16B16A16_UNORM;
        return colorTypeArray2;
    }

    static {
        UNKNOWN = new ColorType();
        ALPHA_8 = new ColorType();
        RGB_565 = new ColorType();
        ARGB_4444 = new ColorType();
        RGBA_8888 = new ColorType();
        RGB_888X = new ColorType();
        BGRA_8888 = new ColorType();
        RGBA_1010102 = new ColorType();
        BGRA_1010102 = new ColorType();
        RGB_101010X = new ColorType();
        BGR_101010X = new ColorType();
        BGR_101010X_XR = new ColorType();
        BGRA_10101010_XR = new ColorType();
        RGBA_10x6 = new ColorType();
        GRAY_8 = new ColorType();
        RGBA_F16NORM = new ColorType();
        RGBA_F16 = new ColorType();
        RGBA_F32 = new ColorType();
        R8G8_UNORM = new ColorType();
        A16_FLOAT = new ColorType();
        R16G16_FLOAT = new ColorType();
        A16_UNORM = new ColorType();
        R16G16_UNORM = new ColorType();
        R16G16B16A16_UNORM = new ColorType();
        $VALUES = ColorType.$values();
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        N32 = BGRA_8888;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/skia/ColorType$Companion;", "", "()V", "N32", "Lorg/jetbrains/skia/ColorType;", "getN32", "()Lorg/jetbrains/skia/ColorType;", "setN32", "(Lorg/jetbrains/skia/ColorType;)V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final ColorType getN32() {
            return N32;
        }

        public final void setN32(ColorType colorType) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
            N32 = colorType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.ALPHA_8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGB_565.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.ARGB_4444.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGBA_8888.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.BGRA_8888.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGB_888X.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGBA_1010102.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGB_101010X.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.BGRA_1010102.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.BGR_101010X.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.BGR_101010X_XR.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.BGRA_10101010_XR.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGBA_10x6.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.GRAY_8.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGBA_F16NORM.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGBA_F16.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.RGBA_F32.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.R8G8_UNORM.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.A16_UNORM.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.R16G16_UNORM.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.A16_FLOAT.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.R16G16_FLOAT.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.R16G16B16A16_UNORM.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

