/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.skia.RRectKt;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skia/RRect;", "Lorg/jetbrains/skia/Rect;", "l", "", "t", "r", "b", "radii", "", "(FFFF[F)V", "getRadii", "()[F", "equals", "", "other", "", "hashCode", "", "inflate", "spread", "toString", "", "Companion", "skiko"})
public final class RRect
extends Rect {
    public static final Companion Companion = new Companion(null);
    private final float[] radii;

    public RRect(float f, float f2, float f3, float f4, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        super(f, f2, f3, f4);
        this.radii = fArray;
    }

    public final float[] getRadii() {
        return this.radii;
    }

    @Override
    public final Rect inflate(float f) {
        int n = 1;
        int n2 = this.radii.length;
        for (int i = 0; i < n2; ++i) {
            if (!(this.radii[i] + f >= 0.0f)) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            return Rect.Companion.makeLTRB(this.getLeft() - f, this.getTop() - f, Math.max(this.getLeft() - f, this.getRight() + f), Math.max(this.getTop() - f, this.getBottom() + f));
        }
        float[] fArray = Arrays.copyOf(this.radii, this.radii.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        float[] fArray2 = fArray;
        n = fArray2.length;
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n2] = Math.max(0.0f, fArray2[n2] + f);
        }
        return new RRect(this.getLeft() - f, this.getTop() - f, Math.max(this.getLeft() - f, this.getRight() + f), Math.max(this.getTop() - f, this.getBottom() + f), fArray2);
    }

    @Override
    public final String toString() {
        return "RRect(_left=" + this.getLeft() + ", _top=" + this.getTop() + ", _right=" + this.getRight() + ", _bottom=" + this.getBottom() + ", _radii=" + ArraysKt.joinToString$default((float[])this.radii, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RRect)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.radii.length == ((RRect)object).radii.length) {
            return Arrays.equals(this.radii, ((RRect)object).radii);
        }
        return Arrays.equals(RRectKt.access$normalizeRadii(this.radii), RRectKt.access$normalizeRadii(((RRect)object).radii));
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 59 + Arrays.hashCode(this.radii);
        return n;
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5) {
        return Companion.makeLTRB(f, f2, f3, f4, f5);
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6) {
        return Companion.makeLTRB(f, f2, f3, f4, f5, f6);
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return Companion.makeLTRB(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @JvmStatic
    public static final RRect makeNinePatchLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return Companion.makeNinePatchLTRB(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @JvmStatic
    public static final RRect makeComplexLTRB(float f, float f2, float f3, float f4, float[] fArray) {
        return Companion.makeComplexLTRB(f, f2, f3, f4, fArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042#\u0010\u0005\u001a\u001f\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\b\nH\u0000\u00a2\u0006\u0002\b\u000bJ)\u0010\f\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u00a2\u0006\u0002\b\u000fJ0\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J.\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0007J8\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0007JH\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012H\u0007JH\u0010#\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0007JF\u0010(\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012J&\u0010)\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J&\u0010*\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012J&\u0010+\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J&\u0010,\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012J.\u0010-\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012J6\u0010-\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012JF\u0010-\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012\u00a8\u0006."}, d2={"Lorg/jetbrains/skia/RRect$Companion;", "", "()V", "fromInteropPointer", "Lorg/jetbrains/skia/RRect;", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "makeComplexLTRB", "l", "", "t", "r", "b", "radii", "", "makeComplexXYWH", "w", "h", "makeLTRB", "radius", "xRad", "yRad", "tlRad", "trRad", "brRad", "blRad", "makeNinePatchLTRB", "lRad", "tRad", "rRad", "bRad", "makeNinePatchXYWH", "makeOvalLTRB", "makeOvalXYWH", "makePillLTRB", "makePillXYWH", "makeXYWH", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final RRect makeLTRB(float f, float f2, float f3, float f4, float f5) {
            float[] fArray = new float[1];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            return new RRect(f, f2, f3, f4, fArray2);
        }

        @JvmStatic
        public final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6) {
            float[] fArray = new float[2];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            fArray2[1] = f6;
            return new RRect(f, f2, f3, f4, fArray2);
        }

        @JvmStatic
        public final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[4];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
            fArray2[3] = f8;
            return new RRect(f, f2, f3, f4, fArray2);
        }

        @JvmStatic
        public final RRect makeNinePatchLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[8];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
            fArray2[3] = f6;
            fArray2[4] = f7;
            fArray2[5] = f8;
            fArray2[6] = f5;
            fArray2[7] = f8;
            return new RRect(f, f2, f3, f4, fArray2);
        }

        @JvmStatic
        public final RRect makeComplexLTRB(float f, float f2, float f3, float f4, float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            return new RRect(f, f2, f3, f4, fArray);
        }

        public final RRect makeOvalLTRB(float f, float f2, float f3, float f4) {
            float[] fArray = new float[2];
            float[] fArray2 = fArray;
            fArray[0] = Math.abs(f3 - f) / 2.0f;
            fArray2[1] = Math.abs(f4 - f2) / 2.0f;
            return new RRect(f, f2, f3, f4, fArray2);
        }

        public final RRect makePillLTRB(float f, float f2, float f3, float f4) {
            float[] fArray = new float[1];
            float[] fArray2 = fArray;
            fArray[0] = Math.min(Math.abs(f3 - f), Math.abs(f2 - f4)) / 2.0f;
            return new RRect(f, f2, f3, f4, fArray2);
        }

        public final RRect makeXYWH(float f, float f2, float f3, float f4, float f5) {
            float[] fArray = new float[1];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            return new RRect(f, f2, f + f3, f2 + f4, fArray2);
        }

        public final RRect makeXYWH(float f, float f2, float f3, float f4, float f5, float f6) {
            float[] fArray = new float[2];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            fArray2[1] = f6;
            return new RRect(f, f2, f + f3, f2 + f4, fArray2);
        }

        public final RRect makeXYWH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[4];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
            fArray2[3] = f8;
            return new RRect(f, f2, f + f3, f2 + f4, fArray2);
        }

        public final RRect makeNinePatchXYWH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[8];
            float[] fArray2 = fArray;
            fArray[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
            fArray2[3] = f6;
            fArray2[4] = f7;
            fArray2[5] = f8;
            fArray2[6] = f5;
            fArray2[7] = f8;
            return new RRect(f, f2, f + f3, f2 + f4, fArray2);
        }

        public final RRect makeComplexXYWH(float f, float f2, float f3, float f4, float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makeOvalXYWH(float f, float f2, float f3, float f4) {
            float[] fArray = new float[2];
            float[] fArray2 = fArray;
            fArray[0] = f3 / 2.0f;
            fArray2[1] = f4 / 2.0f;
            return new RRect(f, f2, f + f3, f2 + f4, fArray2);
        }

        public final RRect makePillXYWH(float f, float f2, float f3, float f4) {
            float[] fArray = new float[1];
            float[] fArray2 = fArray;
            fArray[0] = Math.min(f3, f4) / 2.0f;
            return new RRect(f, f2, f + f3, f2 + f4, fArray2);
        }

        public final RRect fromInteropPointer$skiko(Function2<? super InteropScope, Object, Unit> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            Object object2 = new float[12];
            InteropScope interopScope = theScope.INSTANCE;
            Object object3 = interopScope.toInteropForResult((float[])object2);
            object.invoke((Object)interopScope, object3);
            interopScope.fromInterop(object3, (float[])object2);
            Object object4 = object = (Object)object2;
            object2 = object4;
            return new RRect((float)object[0], (float)object[1], (float)object[2], (float)object[3], ArraysKt.copyOfRange(object4, (int)4, (int)12));
        }

        public final RRect fromInteropPointerNullable$skiko(Function1<Object, Boolean> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            new Ref.BooleanRef().element = true;
            object = this.fromInteropPointer$skiko((Function2<? super InteropScope, Object, Unit>)((Function2)new Function2<InteropScope, Object, Unit>(booleanRef, object){
                final /* synthetic */ Ref.BooleanRef $result;
                final /* synthetic */ Function1<Object, Boolean> $block;
                {
                    this.$result = booleanRef;
                    this.$block = function1;
                    super(2);
                }

                public final void invoke(InteropScope interopScope, Object object) {
                    Intrinsics.checkNotNullParameter((Object)interopScope, (String)"");
                    this.$result.element = (Boolean)this.$block.invoke(object);
                }
            }));
            if (booleanRef.element) {
                return object;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

