/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/skia/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "isEmpty", "", "()Z", "getLeft", "getRight", "getTop", "width", "getWidth", "equals", "other", "hashCode", "", "inflate", "spread", "intersect", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/Point;", "scale", "sx", "sy", "serializeToFloatArray", "", "serializeToFloatArray$skiko", "toIRect", "Lorg/jetbrains/skia/IRect;", "toString", "", "Companion", "skiko"})
public class Rect {
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    public Rect(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    public final Rect intersect(Rect rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"");
        if (this.right <= rect2.left || rect2.right <= this.left || this.bottom <= rect2.top || rect2.bottom <= this.top) {
            return null;
        }
        return new Rect(Math.max(this.left, rect2.left), Math.max(this.top, rect2.top), Math.min(this.right, rect2.right), Math.min(this.bottom, rect2.bottom));
    }

    public final Rect scale(float f) {
        float f2 = f;
        return this.scale(f2, f2);
    }

    public final Rect scale(float f, float f2) {
        return new Rect(this.left * f, this.top * f2, this.right * f, this.bottom * f2);
    }

    public final Rect offset(float f, float f2) {
        return new Rect(this.left + f, this.top + f2, this.right + f, this.bottom + f2);
    }

    public final Rect offset(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        return this.offset(point.getX(), point.getY());
    }

    public final IRect toIRect() {
        return new IRect((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
    }

    public Rect inflate(float f) {
        if (f <= 0.0f) {
            return Companion.makeLTRB(this.left - f, this.top - f, Math.max(this.left - f, this.right + f), Math.max(this.top - f, this.bottom + f));
        }
        return RRect.Companion.makeLTRB(this.left - f, this.top - f, Math.max(this.left - f, this.right + f), Math.max(this.top - f, this.bottom + f), f);
    }

    public final float[] serializeToFloatArray$skiko() {
        float[] fArray = new float[4];
        float[] fArray2 = fArray;
        fArray[0] = this.left;
        fArray2[1] = this.top;
        fArray2[2] = this.right;
        fArray2[3] = this.bottom;
        return fArray2;
    }

    public final boolean isEmpty() {
        return this.right == this.left || this.top == this.bottom;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rect)) {
            return false;
        }
        if (Float.compare(this.left, ((Rect)object).left) != 0) {
            return false;
        }
        if (Float.compare(this.top, ((Rect)object).top) != 0) {
            return false;
        }
        if (Float.compare(this.right, ((Rect)object).right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((Rect)object).bottom) == 0;
    }

    public int hashCode() {
        int n = 59 + Float.floatToIntBits(this.left);
        n = n * 59 + Float.floatToIntBits(this.top);
        n = n * 59 + Float.floatToIntBits(this.right);
        n = n * 59 + Float.floatToIntBits(this.bottom);
        return n;
    }

    public String toString() {
        return "Rect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ')';
    }

    @JvmStatic
    public static final Rect makeLTRB(float f, float f2, float f3, float f4) {
        return Companion.makeLTRB(f, f2, f3, f4);
    }

    @JvmStatic
    public static final Rect makeWH(float f, float f2) {
        return Companion.makeWH(f, f2);
    }

    @JvmStatic
    public static final Rect makeWH(Point point) {
        return Companion.makeWH(point);
    }

    @JvmStatic
    public static final Rect makeXYWH(float f, float f2, float f3, float f4) {
        return Companion.makeXYWH(f, f2, f3, f4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ2\u0010\u0003\u001a\u00020\u00052#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\b\u000eJ)\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001dH\u0007J(\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/Rect$Companion;", "", "()V", "fromInteropPointer", "", "Lorg/jetbrains/skia/Rect;", "size", "", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "(ILkotlin/jvm/functions/Function2;)[Lorg/jetbrains/skia/Rect;", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "makeLTRB", "l", "", "t", "r", "b", "makeWH", "w", "h", "Lorg/jetbrains/skia/Point;", "makeXYWH", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final Rect makeLTRB(float f, float f2, float f3, float f4) {
            return new Rect(f, f2, f3, f4);
        }

        @JvmStatic
        public final Rect makeWH(float f, float f2) {
            return new Rect(0.0f, 0.0f, f, f2);
        }

        @JvmStatic
        public final Rect makeWH(Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            return this.makeWH(point.getX(), point.getY());
        }

        @JvmStatic
        public final Rect makeXYWH(float f, float f2, float f3, float f4) {
            return new Rect(f, f2, f + f3, f2 + f4);
        }

        public final Rect fromInteropPointer$skiko(Function2<? super InteropScope, Object, Unit> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            float[] fArray = new float[4];
            InteropScope interopScope = theScope.INSTANCE;
            Object object2 = interopScope.toInteropForResult(fArray);
            object.invoke((Object)interopScope, object2);
            interopScope.fromInterop(object2, fArray);
            object = fArray;
            return new Rect((float)object[0], (float)object[1], (float)object[2], (float)object[3]);
        }

        public final Rect[] fromInteropPointer$skiko(int n, Function2<? super InteropScope, Object, Unit> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            Object object2 = new float[n];
            Object object3 = theScope.INSTANCE;
            Iterator iterator = ((InteropScope)object3).toInteropForResult((float[])object2);
            object.invoke(object3, (Object)iterator);
            ((InteropScope)object3).fromInterop((Object)iterator, (float[])object2);
            Iterable iterable = CollectionsKt.chunked((Iterable)ArraysKt.toList((float[])object2), (int)4);
            object2 = iterable;
            object = iterable;
            object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object4 = iterator.next();
                object4 = (List)object4;
                Object object5 = object3;
                float f = ((Number)object4.get(0)).floatValue();
                float f2 = ((Number)object4.get(1)).floatValue();
                float f3 = ((Number)object4.get(2)).floatValue();
                float f4 = ((Number)object4.get(3)).floatValue();
                object5.add(new Rect(f, f3, f2, f4));
            }
            Collection collection = (List)object3;
            object = collection;
            return collection.toArray(new Rect[0]);
        }

        public final Rect fromInteropPointerNullable$skiko(Function1<Object, Boolean> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            new Ref.BooleanRef().element = true;
            object = this.fromInteropPointer$skiko((Function2<? super InteropScope, Object, Unit>)((Function2)new Function2<InteropScope, Object, Unit>(booleanRef, object){
                final /* synthetic */ Ref.BooleanRef $result;
                final /* synthetic */ Function1<Object, Boolean> $block;
                {
                    this.$result = booleanRef;
                    this.$block = function1;
                    super(2);
                }

                public final void invoke(InteropScope interopScope, Object object) {
                    Intrinsics.checkNotNullParameter((Object)interopScope, (String)"");
                    this.$result.element = (Boolean)this.$block.invoke(object);
                }
            }));
            if (booleanRef.element) {
                return object;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

