/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingRedrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0017\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0082\bJ\b\u0010\u0015\u001a\u00020\u0011H\u0004J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0004J(\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H$J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "isDisposed", "", "isFirstFrameRendered", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "dispose", "", "inDrawScope", "body", "Lkotlin/Function0;", "onContextInit", "onDeviceChosen", "deviceName", "", "onRender", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "", "redraw", "rendererInfo", "skiko"})
public abstract class SwingRedrawerBase
implements SwingRedrawer {
    private final SwingLayerProperties swingLayerProperties;
    private final SkiaLayerAnalytics analytics;
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public SwingRedrawerBase(SwingLayerProperties swingLayerProperties2, SkiaLayerAnalytics skiaLayerAnalytics, GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        this.swingLayerProperties = swingLayerProperties2;
        this.analytics = skiaLayerAnalytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected abstract void onRender(Graphics2D var1, int var2, int var3, long var4);

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    @Override
    public final void redraw(Graphics2D object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!(!this.isDisposed)) {
            object = this.getClass() + " is disposed";
            throw new IllegalArgumentException(object.toString());
        }
        SwingRedrawerBase swingRedrawerBase = this;
        if (!SwingUtilities.isEventDispatchThread()) {
            object = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(object.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = swingRedrawerBase.deviceAnalytics;
        if (deviceAnalytics == null) {
            object = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(object.toString());
        }
        if (!swingRedrawerBase.isDisposed) {
            if (!swingRedrawerBase.isFirstFrameRendered && (deviceAnalytics = swingRedrawerBase.deviceAnalytics) != null) {
                deviceAnalytics.beforeFirstFrameRender();
            }
            try {
                float f = SwingLayerPropertiesKt.getScale(this.swingLayerProperties);
                int n = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getWidth() * f)), (int)0);
                int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getHeight() * f)), (int)0);
                this.onRender((Graphics2D)object, n, n2, System.nanoTime());
            }
            catch (CancellationException cancellationException) {}
            if (!swingRedrawerBase.isFirstFrameRendered && !swingRedrawerBase.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = swingRedrawerBase.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.afterFirstFrameRender();
                }
            }
            swingRedrawerBase.isFirstFrameRendered = true;
        }
    }

    protected final void onDeviceChosen(String string) {
        if (!(!this.isDisposed)) {
            string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.deviceAnalytics == null)) {
            string = "deviceAnalytics is not null";
            throw new IllegalArgumentException(string.toString());
        }
        this.rendererAnalytics.deviceChosen();
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, string);
        if (deviceAnalytics != null) {
            deviceAnalytics.init();
            return;
        }
    }

    protected String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.graphicsApi) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    protected final void onContextInit() {
        Object object;
        if (!(!this.isDisposed)) {
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.deviceAnalytics == null) {
            String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(object = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.info("Renderer info:\n " + this.rendererInfo());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
        if (deviceAnalytics != null) {
            deviceAnalytics.contextInit();
            return;
        }
    }

    private final void inDrawScope(Function0<Unit> object) {
        if (!SwingUtilities.isEventDispatchThread()) {
            object = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(object.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
        if (deviceAnalytics == null) {
            object = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(object.toString());
        }
        if (!this.isDisposed) {
            if (!this.isFirstFrameRendered && (deviceAnalytics = this.deviceAnalytics) != null) {
                deviceAnalytics.beforeFirstFrameRender();
            }
            try {
                object.invoke();
            }
            catch (CancellationException cancellationException) {}
            if (!this.isFirstFrameRendered && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = this.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.afterFirstFrameRender();
                }
            }
            this.isFirstFrameRendered = true;
        }
    }
}

