/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jul;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.JULHelper;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.LogManager;

public class LevelChangePropagator
extends ContextAwareBase
implements LoggerContextListener,
LifeCycle {
    private Set<java.util.logging.Logger> julLoggerSet = new HashSet<java.util.logging.Logger>();
    boolean isStarted = false;
    boolean resetJUL = false;

    public void setResetJUL(boolean bl) {
        this.resetJUL = bl;
    }

    @Override
    public boolean isResetResistant() {
        return false;
    }

    @Override
    public void onStart(LoggerContext loggerContext) {
    }

    @Override
    public void onReset(LoggerContext loggerContext) {
    }

    @Override
    public void onStop(LoggerContext loggerContext) {
    }

    @Override
    public void onLevelChange(Logger logger, Level level) {
        this.propagate(logger, level);
    }

    private void propagate(Logger object, Level serializable) {
        this.addInfo("Propagating " + String.valueOf(serializable) + " level on " + String.valueOf(object) + " onto the JUL framework");
        object = JULHelper.asJULLogger((Logger)object);
        this.julLoggerSet.add((java.util.logging.Logger)object);
        serializable = JULHelper.asJULLevel(serializable);
        ((java.util.logging.Logger)object).setLevel((java.util.logging.Level)serializable);
    }

    public void resetJULLevels() {
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> enumeration = logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            java.util.logging.Logger logger = logManager.getLogger(string);
            if (!JULHelper.isRegularNonRootLogger(logger) || logger.getLevel() == null) continue;
            this.addInfo("Setting level of jul logger [" + string + "] to null");
            logger.setLevel(null);
        }
    }

    private void propagateExistingLoggerLevels() {
        Object object = (LoggerContext)this.context;
        object = ((LoggerContext)((Object)object)).getLoggerList();
        object = object.iterator();
        while (object.hasNext()) {
            Logger logger = (Logger)object.next();
            if (logger.getLevel() == null) continue;
            Logger logger2 = logger;
            this.propagate(logger2, logger2.getLevel());
        }
    }

    public void start() {
        if (this.resetJUL) {
            this.resetJULLevels();
        }
        this.propagateExistingLoggerLevels();
        this.isStarted = true;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }
}

