/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import javax.net.ssl.SSLException;

public abstract class ApplicationProtocolNegotiationHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;
    private final RecyclableArrayList bufferedMessages = RecyclableArrayList.newInstance();
    private ChannelHandlerContext ctx;
    private boolean sslHandlerChecked;

    protected ApplicationProtocolNegotiationHandler(String string) {
        this.fallbackProtocol = (String)ObjectUtil.checkNotNull((Object)string, (String)"fallbackProtocol");
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.fireBufferedMessages();
        this.bufferedMessages.recycle();
        super.handlerRemoved(channelHandlerContext);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.bufferedMessages.add(object);
        if (!this.sslHandlerChecked) {
            this.sslHandlerChecked = true;
            if (channelHandlerContext.pipeline().get(SslHandler.class) == null) {
                this.removeSelfIfPresent(channelHandlerContext);
            }
        }
    }

    private void fireBufferedMessages() {
        if (!this.bufferedMessages.isEmpty()) {
            for (int i = 0; i < this.bufferedMessages.size(); ++i) {
                this.ctx.fireChannelRead(this.bufferedMessages.get(i));
            }
            this.ctx.fireChannelReadComplete();
            this.bufferedMessages.clear();
        }
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)object;
            try {
                if (sslHandshakeCompletionEvent.isSuccess()) {
                    Object object2 = (SslHandler)channelHandlerContext.pipeline().get(SslHandler.class);
                    if (object2 == null) {
                        throw new IllegalStateException("cannot find an SslHandler in the pipeline (required for application-level protocol negotiation)");
                    }
                    this.configurePipeline(channelHandlerContext, (String)((object2 = object2.applicationProtocol()) != null ? object2 : this.fallbackProtocol));
                }
            }
            catch (Throwable throwable) {
                this.exceptionCaught(channelHandlerContext, throwable);
            }
            finally {
                if (sslHandshakeCompletionEvent.isSuccess()) {
                    this.removeSelfIfPresent(channelHandlerContext);
                }
            }
        }
        if (object instanceof ChannelInputShutdownEvent) {
            this.fireBufferedMessages();
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.fireBufferedMessages();
        super.channelInactive(channelHandlerContext);
    }

    private void removeSelfIfPresent(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (!channelHandlerContext.isRemoved()) {
            channelPipeline.remove((ChannelHandler)this);
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2);

    protected void handshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("{} TLS handshake failed:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.close();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof DecoderException && (throwable2 = throwable.getCause()) instanceof SSLException) {
            try {
                this.handshakeFailure(channelHandlerContext, throwable2);
                return;
            }
            finally {
                this.removeSelfIfPresent(channelHandlerContext);
            }
        }
        logger.warn("{} Failed to select the application-level protocol:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.fireExceptionCaught(throwable);
        channelHandlerContext.close();
    }
}

