/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class EnhancingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager wrapped;

    EnhancingX509ExtendedTrustManager(X509TrustManager x509TrustManager) {
        this.wrapped = (X509ExtendedTrustManager)x509TrustManager;
    }

    @Override
    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) {
        this.wrapped.checkClientTrusted(x509CertificateArray, string, socket);
    }

    @Override
    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) {
        try {
            this.wrapped.checkServerTrusted(x509CertificateArray, string, socket);
            return;
        }
        catch (CertificateException certificateException) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(x509CertificateArray, certificateException);
            return;
        }
    }

    @Override
    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) {
        this.wrapped.checkClientTrusted(x509CertificateArray, string, sSLEngine);
    }

    @Override
    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) {
        try {
            this.wrapped.checkServerTrusted(x509CertificateArray, string, sSLEngine);
            return;
        }
        catch (CertificateException certificateException) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(x509CertificateArray, certificateException);
            return;
        }
    }

    @Override
    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        this.wrapped.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        try {
            this.wrapped.checkServerTrusted(x509CertificateArray, string);
            return;
        }
        catch (CertificateException certificateException) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(x509CertificateArray, certificateException);
            return;
        }
    }

    @Override
    public final X509Certificate[] getAcceptedIssuers() {
        return this.wrapped.getAcceptedIssuers();
    }

    private static void throwEnhancedCertificateException(X509Certificate[] x509CertificateArray, CertificateException certificateException) {
        String string = certificateException.getMessage();
        if (string != null && certificateException.getMessage().startsWith("No subject alternative DNS name matching")) {
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                Iterator iterator = x509CertificateArray[i];
                if ((iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames()) == null) continue;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    if (list.size() < 2 || (Integer)list.get(0) != 2) continue;
                    stringBuilder.append((String)list.get(1)).append(",");
                }
            }
            if (stringBuilder.length() != 0) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.setLength(stringBuilder2.length() - 1);
                throw new CertificateException(string + " Subject alternative DNS names in the certificate chain of " + x509CertificateArray.length + " certificate(s): " + stringBuilder, certificateException);
            }
        }
        throw certificateException;
    }
}

