/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslInternalSession;
import io.netty.handler.ssl.OpenSslSessionCache;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<HostPort, Set<OpenSslSessionCache.NativeSslSession>> sessions = new HashMap<HostPort, Set<OpenSslSessionCache.NativeSslSession>>();

    OpenSslClientSessionCache(OpenSslEngineMap openSslEngineMap) {
        super(openSslEngineMap);
    }

    @Override
    protected final boolean sessionCreated(OpenSslSessionCache.NativeSslSession nativeSslSession) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(nativeSslSession.getPeerHost(), nativeSslSession.getPeerPort());
        if (hostPort == null) {
            return false;
        }
        Set<OpenSslSessionCache.NativeSslSession> set = this.sessions.get(hostPort);
        if (set == null) {
            set = new HashSet<OpenSslSessionCache.NativeSslSession>(4);
            this.sessions.put(hostPort, set);
        }
        set.add(nativeSslSession);
        return true;
    }

    @Override
    protected final void sessionRemoved(OpenSslSessionCache.NativeSslSession nativeSslSession) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(nativeSslSession.getPeerHost(), nativeSslSession.getPeerPort());
        if (hostPort == null) {
            return;
        }
        Set<OpenSslSessionCache.NativeSslSession> set = this.sessions.get(hostPort);
        if (set != null) {
            set.remove(nativeSslSession);
            if (set.isEmpty()) {
                this.sessions.remove(hostPort);
            }
        }
    }

    @Override
    final boolean setSession(long l, OpenSslInternalSession openSslInternalSession, String arrayList, int n) {
        boolean bl;
        if ((arrayList = OpenSslClientSessionCache.keyFor((String)((Object)arrayList), n)) == null) {
            return false;
        }
        OpenSslSessionCache.NativeSslSession nativeSslSession = null;
        boolean bl2 = false;
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            Iterator iterator = this.sessions.get(arrayList);
            if (iterator == null) {
                return false;
            }
            if (iterator.isEmpty()) {
                this.sessions.remove(arrayList);
                return false;
            }
            arrayList = null;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                OpenSslSessionCache.NativeSslSession nativeSslSession2 = (OpenSslSessionCache.NativeSslSession)iterator.next();
                if (nativeSslSession2.isValid()) {
                    nativeSslSession = nativeSslSession2;
                    break;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<OpenSslSessionCache.NativeSslSession>(2);
                }
                arrayList.add(nativeSslSession2);
            }
            if (arrayList != null) {
                for (OpenSslSessionCache.NativeSslSession nativeSslSession2 : arrayList) {
                    this.removeSessionWithId(nativeSslSession2.sessionId());
                }
            }
            if (nativeSslSession == null) {
                return false;
            }
            bl = SSL.setSession((long)l, (long)nativeSslSession.session());
            if (bl) {
                bl2 = nativeSslSession.shouldBeSingleUse();
            }
        }
        if (bl) {
            if (bl2) {
                nativeSslSession.invalidate();
                openSslInternalSession.invalidate();
            }
            nativeSslSession.setLastAccessedTime(System.currentTimeMillis());
            openSslInternalSession.setSessionDetails(nativeSslSession.getCreationTime(), nativeSslSession.getLastAccessedTime(), nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        }
        return bl;
    }

    private static HostPort keyFor(String string, int n) {
        if (string == null && n <= 0) {
            return null;
        }
        return new HostPort(string, n);
    }

    @Override
    final synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }

    private static final class HostPort {
        private final int hash;
        private final String host;
        private final int port;

        HostPort(String string, int n) {
            this.host = string;
            this.port = n;
            this.hash = 31 * AsciiString.hashCode((CharSequence)string) + n;
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof HostPort)) {
                return false;
            }
            object = (HostPort)object;
            return this.port == ((HostPort)object).port && this.host.equalsIgnoreCase(((HostPort)object).host);
        }

        public final String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

