/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslClientSessionCache;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContextOption;
import io.netty.internal.tcnative.CertificateCallback;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.util.internal.EmptyArrays;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public final class ReferenceCountedOpenSslClientContext
extends ReferenceCountedOpenSslContext {
    private static final Set<String> SUPPORTED_KEY_TYPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("RSA", "DH_RSA", "EC", "EC_RSA", "EC_EC")));
    private final OpenSslSessionContext sessionContext;

    ReferenceCountedOpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l, long l2, boolean bl, String string2, String string3, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        super(iterable, cipherSuiteFilter, ReferenceCountedOpenSslClientContext.toNegotiator(applicationProtocolConfig), 0, x509CertificateArray2, ClientAuth.NONE, stringArray, false, string3, bl, true, resumptionController, entryArray);
        try {
            this.sessionContext = ReferenceCountedOpenSslClientContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l, l2, resumptionController);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    static OpenSslSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] object, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2, long l2, long l3, ResumptionController resumptionController) {
        if (privateKey == null && object != null || privateKey != null && object == null) {
            throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
        }
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object2;
            try {
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    if (object != null) {
                        ReferenceCountedOpenSslClientContext.setKeyMaterial(l, object, privateKey, string);
                    }
                } else {
                    if (keyManagerFactory == null && object != null) {
                        object2 = ReferenceCountedOpenSslClientContext.keyStorePassword(string);
                        keyManagerFactory = (object = ReferenceCountedOpenSslClientContext.buildKeyStore(object, privateKey, object2, string2)).aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    } else if (keyManagerFactory != null) {
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    }
                    if (openSslKeyMaterialProvider != null) {
                        object2 = new OpenSslKeyMaterialManager(openSslKeyMaterialProvider);
                        SSLContext.setCertificateCallback((long)l, (CertificateCallback)new OpenSslClientCertificateCallback(openSslEngineMap, (OpenSslKeyMaterialManager)object2));
                    }
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            SSLContext.setVerify((long)l, (int)1, (int)10);
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslClientContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers(), resumptionController);
                ReferenceCountedOpenSslClientContext.setVerifyCallback(l, openSslEngineMap, (X509TrustManager)object2);
            }
            catch (Exception exception) {
                if (openSslKeyMaterialProvider != null) {
                    openSslKeyMaterialProvider.destroy();
                }
                throw new SSLException("unable to setup trustmanager", exception);
            }
            OpenSslClientSessionContext openSslClientSessionContext = new OpenSslClientSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            object2 = openSslClientSessionContext;
            openSslClientSessionContext.setSessionCacheEnabled(CLIENT_ENABLE_SESSION_CACHE);
            if (l2 > 0L) {
                object2.setSessionCacheSize((int)Math.min(l2, Integer.MAX_VALUE));
            }
            if (l3 > 0L) {
                object2.setSessionTimeout((int)Math.min(l3, Integer.MAX_VALUE));
            }
            if (CLIENT_ENABLE_SESSION_TICKET) {
                object2.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        catch (Throwable throwable) {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
            throw throwable;
        }
    }

    private static void setVerifyCallback(long l, OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslClientContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)x509TrustManager));
            return;
        }
        SSLContext.setCertVerifyCallback((long)l, (CertificateVerifier)new TrustManagerVerifyCallback(openSslEngineMap, x509TrustManager));
    }

    private static final class OpenSslClientCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslClientCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }

        public final void handle(long l, byte[] objectArray, byte[][] byArray) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
            if (referenceCountedOpenSslEngine == null) {
                return;
            }
            try {
                String[] stringArray = OpenSslClientCertificateCallback.supportedClientKeyTypes(objectArray);
                stringArray = stringArray.toArray(EmptyArrays.EMPTY_STRINGS);
                if (byArray == null) {
                    objectArray = null;
                } else {
                    objectArray = new X500Principal[byArray.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        objectArray[i] = (byte)new X500Principal(byArray[i]);
                    }
                }
                this.keyManagerHolder.setKeyMaterialClientSide(referenceCountedOpenSslEngine, stringArray, (X500Principal[])objectArray);
                return;
            }
            catch (Throwable throwable) {
                referenceCountedOpenSslEngine.initHandshakeException(throwable);
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new SSLException(throwable);
            }
        }

        private static Set<String> supportedClientKeyTypes(byte[] byArray) {
            if (byArray == null) {
                return SUPPORTED_KEY_TYPES;
            }
            HashSet<String> hashSet = new HashSet<String>(byArray.length);
            for (byte by : byArray) {
                String string = OpenSslClientCertificateCallback.clientKeyType(by);
                if (string == null) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        private static String clientKeyType(byte by) {
            switch (by) {
                case 1: {
                    return "RSA";
                }
                case 3: {
                    return "DH_RSA";
                }
                case 64: {
                    return "EC";
                }
                case 65: {
                    return "EC_RSA";
                }
                case 66: {
                    return "EC_EC";
                }
            }
            return null;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = x509ExtendedTrustManager;
        }

        @Override
        final void verify(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, X509Certificate[] x509CertificateArray, String string) {
            this.manager.checkServerTrusted(x509CertificateArray, string, referenceCountedOpenSslEngine);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }

        @Override
        final void verify(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, X509Certificate[] x509CertificateArray, String string) {
            this.manager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        OpenSslClientSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
            super(referenceCountedOpenSslContext, openSslKeyMaterialProvider, SSL.SSL_SESS_CACHE_CLIENT, new OpenSslClientSessionCache(referenceCountedOpenSslContext.engineMap));
        }
    }
}

