/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.ResumableX509ExtendedTrustManager;
import io.netty.util.internal.PlatformDependent;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

final class ResumptionController {
    private final Set<SSLEngine> confirmedValidations = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final AtomicReference<ResumableX509ExtendedTrustManager> resumableTm = new AtomicReference();

    ResumptionController() {
    }

    public final TrustManager wrapIfNeeded(TrustManager trustManager) {
        if (trustManager instanceof ResumableX509ExtendedTrustManager) {
            if (PlatformDependent.javaVersion() < 7 || !(trustManager instanceof X509ExtendedTrustManager)) {
                throw new IllegalStateException("ResumableX509ExtendedTrustManager implementation must be a subclass of X509ExtendedTrustManager, found: " + (trustManager == null ? null : trustManager.getClass()));
            }
            if (!this.resumableTm.compareAndSet(null, (ResumableX509ExtendedTrustManager)trustManager)) {
                throw new IllegalStateException("Only one ResumableX509ExtendedTrustManager can be configured for resumed sessions");
            }
            return new X509ExtendedWrapTrustManager((X509ExtendedTrustManager)trustManager, this.confirmedValidations);
        }
        return trustManager;
    }

    public final void remove(SSLEngine sSLEngine) {
        if (this.resumableTm.get() != null) {
            this.confirmedValidations.remove(ResumptionController.unwrapEngine(sSLEngine));
        }
    }

    public final boolean validateResumeIfNeeded(SSLEngine sSLEngine) {
        ResumableX509ExtendedTrustManager resumableX509ExtendedTrustManager;
        Certificate[] certificateArray = sSLEngine.getSession();
        boolean bl = certificateArray.isValid();
        if (bl && (sSLEngine.getUseClientMode() || sSLEngine.getNeedClientAuth() || sSLEngine.getWantClientAuth()) && (resumableX509ExtendedTrustManager = this.resumableTm.get()) != null && !this.confirmedValidations.remove(sSLEngine = ResumptionController.unwrapEngine(sSLEngine))) {
            try {
                certificateArray = certificateArray.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (sSLEngine.getUseClientMode() || sSLEngine.getNeedClientAuth()) {
                    throw sSLPeerUnverifiedException;
                }
                return false;
            }
            if (sSLEngine.getUseClientMode()) {
                resumableX509ExtendedTrustManager.resumeServerTrusted(ResumptionController.chainOf(certificateArray), sSLEngine);
            } else {
                resumableX509ExtendedTrustManager.resumeClientTrusted(ResumptionController.chainOf(certificateArray), sSLEngine);
            }
            return true;
        }
        return false;
    }

    private static SSLEngine unwrapEngine(SSLEngine sSLEngine) {
        if (sSLEngine instanceof JdkSslEngine) {
            return ((JdkSslEngine)sSLEngine).getWrappedEngine();
        }
        return sSLEngine;
    }

    private static X509Certificate[] chainOf(Certificate[] certificateArray) {
        if (certificateArray instanceof X509Certificate[]) {
            return (X509Certificate[])certificateArray;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate) && certificate != null) {
                throw new IllegalArgumentException("Only X509Certificates are supported, found: " + certificate.getClass());
            }
            x509CertificateArray[i] = (X509Certificate)certificate;
        }
        return x509CertificateArray;
    }

    private static final class X509ExtendedWrapTrustManager
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager trustManager;
        private final Set<SSLEngine> confirmedValidations;

        X509ExtendedWrapTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager, Set<SSLEngine> set) {
            this.trustManager = x509ExtendedTrustManager;
            this.confirmedValidations = set;
        }

        private static void unsupported() {
            throw new CertificateException(new UnsupportedOperationException("Resumable trust managers require the SSLEngine parameter"));
        }

        @Override
        public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) {
            this.trustManager.checkClientTrusted(x509CertificateArray, string, sSLEngine);
            this.confirmedValidations.add(sSLEngine);
        }

        @Override
        public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) {
            this.trustManager.checkServerTrusted(x509CertificateArray, string, sSLEngine);
            this.confirmedValidations.add(sSLEngine);
        }

        @Override
        public final X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

