/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FingerprintTrustManagerFactoryBuilder {
    private final String algorithm;
    private final List<String> fingerprints = new ArrayList<String>();

    FingerprintTrustManagerFactoryBuilder(String string) {
        this.algorithm = (String)ObjectUtil.checkNotNull((Object)string, (String)"algorithm");
    }

    public final FingerprintTrustManagerFactoryBuilder fingerprints(CharSequence ... charSequenceArray) {
        return this.fingerprints(Arrays.asList((Object[])ObjectUtil.checkNotNull((Object)charSequenceArray, (String)"fingerprints")));
    }

    public final FingerprintTrustManagerFactoryBuilder fingerprints(Iterable<? extends CharSequence> object) {
        ObjectUtil.checkNotNull(object, (String)"fingerprints");
        object = object.iterator();
        while (object.hasNext()) {
            CharSequence charSequence = (CharSequence)object.next();
            ObjectUtil.checkNotNullWithIAE((Object)charSequence, (String)"fingerprint");
            this.fingerprints.add(charSequence.toString());
        }
        return this;
    }

    public final FingerprintTrustManagerFactory build() {
        if (this.fingerprints.isEmpty()) {
            throw new IllegalStateException("No fingerprints provided");
        }
        return new FingerprintTrustManagerFactory(this.algorithm, FingerprintTrustManagerFactory.toFingerprintArray(this.fingerprints));
    }
}

