/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.ByteArrayPool;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringOpsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0002J\u0011\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000bH\u0082\bJ\u0011\u0010\u0013\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000bH\u0082\bJ\t\u0010\"\u001a\u00020\u000bH\u0082\bJ\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkotlinx/serialization/json/internal/JsonToJavaStreamWriter;", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "stream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "buffer", "", "charArray", "", "indexInBuffer", "", "writeLong", "", "value", "", "writeChar", "char", "", "write", "text", "", "writeQuoted", "appendStringSlowPath", "currentSize", "string", "ensureTotalCapacity", "oldSize", "additional", "release", "flush", "ensure", "bytesCount", "byte", "rest", "writeUtf8", "count", "writeUtf8CodePoint", "codePoint", "kotlinx-serialization-json"})
public final class JsonToJavaStreamWriter
implements InternalJsonWriter {
    private final OutputStream stream;
    private final byte[] buffer;
    private char[] charArray;
    private int indexInBuffer;

    public JsonToJavaStreamWriter(OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"");
        this.stream = outputStream;
        this.buffer = ByteArrayPool.INSTANCE.take();
        this.charArray = CharArrayPool.INSTANCE.take();
    }

    @Override
    public final void writeLong(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public final void writeChar(char c) {
        this.writeUtf8CodePoint(c);
    }

    @Override
    public final void write(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = string.length();
        this.ensureTotalCapacity(0, n);
        char[] cArray = this.charArray;
        string.getChars(0, n, cArray, 0);
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        jsonToJavaStreamWriter.writeUtf8(jsonToJavaStreamWriter.charArray, n);
    }

    @Override
    public final void writeQuoted(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.ensureTotalCapacity(0, string.length() + 2);
        char[] cArray = this.charArray;
        this.charArray[0] = 34;
        int n = string.length();
        String string2 = string;
        string2.getChars(0, n, cArray, 1);
        int n2 = n + 1;
        for (int i = 1; i < n2; ++i) {
            char c = cArray[i];
            if (c >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[c] == 0) continue;
            this.appendStringSlowPath(i, string);
            return;
        }
        cArray[n + 1] = 34;
        this.writeUtf8(cArray, n + 2);
        this.flush();
    }

    private final void appendStringSlowPath(int n, String string) {
        int n2 = n--;
        int n3 = string.length();
        while (n < n3) {
            byte by;
            n2 = this.ensureTotalCapacity(n2, 2);
            char c = string.charAt(n);
            if (c < StringOpsKt.getESCAPE_MARKERS().length && (by = StringOpsKt.getESCAPE_MARKERS()[c]) != 0) {
                if (by == 1) {
                    String string2;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[c]);
                    n2 = this.ensureTotalCapacity(n2, string2.length());
                    String string3 = string2;
                    char[] cArray = this.charArray;
                    int n4 = string2.length();
                    string3.getChars(0, n4, cArray, n2);
                    n2 += string2.length();
                } else {
                    this.charArray[n2] = 92;
                    this.charArray[n2 + 1] = (char)by;
                    n2 += 2;
                }
            } else {
                this.charArray[n2++] = c;
            }
            ++n;
        }
        this.ensureTotalCapacity(n2, 1);
        this.charArray[n2++] = 34;
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        jsonToJavaStreamWriter.writeUtf8(jsonToJavaStreamWriter.charArray, n2);
        this.flush();
    }

    private final int ensureTotalCapacity(int n, int n2) {
        if (this.charArray.length <= (n2 = n + n2)) {
            char[] cArray = Arrays.copyOf(this.charArray, RangesKt.coerceAtLeast((int)n2, (int)(n << 1)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"");
            this.charArray = cArray;
        }
        return n;
    }

    @Override
    public final void release() {
        this.flush();
        CharArrayPool.INSTANCE.release(this.charArray);
        ByteArrayPool.INSTANCE.release(this.buffer);
    }

    private final void flush() {
        this.stream.write(this.buffer, 0, this.indexInBuffer);
        this.indexInBuffer = 0;
    }

    private final void ensure(int n) {
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter.indexInBuffer < n) {
            this.flush();
        }
    }

    private final void write(int n) {
        int n2 = this.indexInBuffer;
        this.indexInBuffer = n2 + 1;
        this.buffer[n2] = (byte)n;
    }

    private final int rest() {
        return this.buffer.length - this.indexInBuffer;
    }

    private final void writeUtf8(char[] cArray, int n) {
        if (!(n >= 0)) {
            String string = "count < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n <= cArray.length)) {
            String string = "count > string.length: " + n + " > " + cArray.length;
            throw new IllegalArgumentException(string.toString());
        }
        int n2 = 0;
        while (n2 < n) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter;
            char c;
            int n3;
            block17: {
                JsonToJavaStreamWriter jsonToJavaStreamWriter2;
                block16: {
                    JsonToJavaStreamWriter jsonToJavaStreamWriter3;
                    n3 = cArray[n2];
                    if (n3 < 128) {
                        JsonToJavaStreamWriter jsonToJavaStreamWriter4;
                        jsonToJavaStreamWriter3 = jsonToJavaStreamWriter4 = this;
                        if (jsonToJavaStreamWriter4.buffer.length - jsonToJavaStreamWriter3.indexInBuffer <= 0) {
                            jsonToJavaStreamWriter4.flush();
                        }
                        jsonToJavaStreamWriter4 = this;
                        int n4 = jsonToJavaStreamWriter4.indexInBuffer;
                        jsonToJavaStreamWriter4.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter4.buffer[n4] = (byte)n3;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter5 = this;
                        int n5 = ++n2 + (jsonToJavaStreamWriter5.buffer.length - jsonToJavaStreamWriter5.indexInBuffer);
                        int n6 = Math.min(n, n5);
                        while (n2 < n6 && (n3 = cArray[n2]) < 128) {
                            JsonToJavaStreamWriter jsonToJavaStreamWriter6 = this;
                            int n7 = jsonToJavaStreamWriter6.indexInBuffer;
                            jsonToJavaStreamWriter6.indexInBuffer = n7 + 1;
                            jsonToJavaStreamWriter6.buffer[n7] = (byte)n3;
                            ++n2;
                        }
                        continue;
                    }
                    if (n3 < 2048) {
                        JsonToJavaStreamWriter jsonToJavaStreamWriter7;
                        jsonToJavaStreamWriter3 = jsonToJavaStreamWriter7 = this;
                        if (jsonToJavaStreamWriter7.buffer.length - jsonToJavaStreamWriter3.indexInBuffer < 2) {
                            jsonToJavaStreamWriter7.flush();
                        }
                        jsonToJavaStreamWriter7 = this;
                        int n8 = n3 >> 6 | 0xC0;
                        int n9 = jsonToJavaStreamWriter7.indexInBuffer;
                        jsonToJavaStreamWriter7.indexInBuffer = n9 + 1;
                        jsonToJavaStreamWriter7.buffer[n9] = (byte)n8;
                        jsonToJavaStreamWriter7 = this;
                        n8 = n3 & 0x3F | 0x80;
                        n9 = jsonToJavaStreamWriter7.indexInBuffer;
                        jsonToJavaStreamWriter7.indexInBuffer = n9 + 1;
                        jsonToJavaStreamWriter7.buffer[n9] = (byte)n8;
                        ++n2;
                        continue;
                    }
                    if (n3 < 55296 || n3 > 57343) {
                        JsonToJavaStreamWriter jsonToJavaStreamWriter8;
                        jsonToJavaStreamWriter3 = jsonToJavaStreamWriter8 = this;
                        if (jsonToJavaStreamWriter8.buffer.length - jsonToJavaStreamWriter3.indexInBuffer < 3) {
                            jsonToJavaStreamWriter8.flush();
                        }
                        jsonToJavaStreamWriter8 = this;
                        int n10 = n3 >> 12 | 0xE0;
                        int n11 = jsonToJavaStreamWriter8.indexInBuffer;
                        jsonToJavaStreamWriter8.indexInBuffer = n11 + 1;
                        jsonToJavaStreamWriter8.buffer[n11] = (byte)n10;
                        jsonToJavaStreamWriter8 = this;
                        n10 = n3 >> 6 & 0x3F | 0x80;
                        n11 = jsonToJavaStreamWriter8.indexInBuffer;
                        jsonToJavaStreamWriter8.indexInBuffer = n11 + 1;
                        jsonToJavaStreamWriter8.buffer[n11] = (byte)n10;
                        jsonToJavaStreamWriter8 = this;
                        n10 = n3 & 0x3F | 0x80;
                        n11 = jsonToJavaStreamWriter8.indexInBuffer;
                        jsonToJavaStreamWriter8.indexInBuffer = n11 + 1;
                        jsonToJavaStreamWriter8.buffer[n11] = (byte)n10;
                        ++n2;
                        continue;
                    }
                    char c2 = c = n2 + 1 < n ? cArray[n2 + 1] : (char)'\u0000';
                    if (n3 > 56319) break block16;
                    if ('\udc00' <= c ? c < '\ue000' : false) break block17;
                }
                JsonToJavaStreamWriter jsonToJavaStreamWriter9 = jsonToJavaStreamWriter2 = this;
                if (jsonToJavaStreamWriter2.buffer.length - jsonToJavaStreamWriter9.indexInBuffer <= 0) {
                    jsonToJavaStreamWriter2.flush();
                }
                jsonToJavaStreamWriter2 = this;
                n3 = jsonToJavaStreamWriter2.indexInBuffer;
                jsonToJavaStreamWriter2.indexInBuffer = n3 + 1;
                jsonToJavaStreamWriter2.buffer[n3] = 63;
                ++n2;
                continue;
            }
            int n12 = 65536 + ((n3 & 0x3FF) << 10 | c & 0x3FF);
            JsonToJavaStreamWriter jsonToJavaStreamWriter10 = jsonToJavaStreamWriter = this;
            if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter10.indexInBuffer < 4) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            int n13 = n12 >> 18 | 0xF0;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n13;
            jsonToJavaStreamWriter = this;
            n13 = n12 >> 12 & 0x3F | 0x80;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n13;
            jsonToJavaStreamWriter = this;
            n13 = n12 >> 6 & 0x3F | 0x80;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n13;
            jsonToJavaStreamWriter = this;
            n13 = n12 & 0x3F | 0x80;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n13;
            n2 += 2;
        }
    }

    private final void writeUtf8CodePoint(int n) {
        if (n < 128) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter;
            JsonToJavaStreamWriter jsonToJavaStreamWriter2 = jsonToJavaStreamWriter = this;
            if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter2.indexInBuffer <= 0) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            int n2 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n2 + 1;
            jsonToJavaStreamWriter.buffer[n2] = (byte)n;
            return;
        }
        if (n < 2048) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter;
            JsonToJavaStreamWriter jsonToJavaStreamWriter3 = jsonToJavaStreamWriter = this;
            if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter3.indexInBuffer < 2) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            int n3 = n >> 6 | 0xC0;
            int n4 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
            jsonToJavaStreamWriter.buffer[n4] = (byte)n3;
            jsonToJavaStreamWriter = this;
            n3 = n & 0x3F | 0x80;
            n4 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
            jsonToJavaStreamWriter.buffer[n4] = (byte)n3;
            return;
        }
        boolean bl = 55296 <= n ? n < 57344 : false;
        if (bl) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter;
            JsonToJavaStreamWriter jsonToJavaStreamWriter4 = jsonToJavaStreamWriter = this;
            if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter4.indexInBuffer <= 0) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            int n5 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n5 + 1;
            jsonToJavaStreamWriter.buffer[n5] = 63;
            return;
        }
        if (n < 65536) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter;
            JsonToJavaStreamWriter jsonToJavaStreamWriter5 = jsonToJavaStreamWriter = this;
            if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter5.indexInBuffer < 3) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            int n6 = n >> 12 | 0xE0;
            int n7 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n7 + 1;
            jsonToJavaStreamWriter.buffer[n7] = (byte)n6;
            jsonToJavaStreamWriter = this;
            n6 = n >> 6 & 0x3F | 0x80;
            n7 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n7 + 1;
            jsonToJavaStreamWriter.buffer[n7] = (byte)n6;
            jsonToJavaStreamWriter = this;
            n6 = n & 0x3F | 0x80;
            n7 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n7 + 1;
            jsonToJavaStreamWriter.buffer[n7] = (byte)n6;
            return;
        }
        if (n <= 0x10FFFF) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter;
            JsonToJavaStreamWriter jsonToJavaStreamWriter6 = jsonToJavaStreamWriter = this;
            if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter6.indexInBuffer < 4) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            int n8 = n >> 18 | 0xF0;
            int n9 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
            jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
            jsonToJavaStreamWriter = this;
            n8 = n >> 12 & 0x3F | 0x80;
            n9 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
            jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
            jsonToJavaStreamWriter = this;
            n8 = n >> 6 & 0x3F | 0x80;
            n9 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
            jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
            jsonToJavaStreamWriter = this;
            n8 = n & 0x3F | 0x80;
            n9 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
            jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
            return;
        }
        throw new JsonEncodingException("Unexpected code point: " + n);
    }
}

