/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization.kotlinx;

import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.WebsocketConverterNotFoundException;
import io.ktor.serialization.WebsocketDeserializeException;
import io.ktor.serialization.kotlinx.SerializerLookupKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameCommonKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u000e\u001a\u00020\r2\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J-\u0010\u0019\u001a\u00020\r2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter;", "Lio/ktor/serialization/WebsocketContentConverter;", "Lkotlinx/serialization/SerialFormat;", "format", "<init>", "(Lkotlinx/serialization/SerialFormat;)V", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "Lio/ktor/util/reflect/TypeInfo;", "typeInfo", "", "value", "Lio/ktor/websocket/Frame;", "serialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "content", "deserialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Lio/ktor/websocket/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "frame", "", "isApplicable", "(Lio/ktor/websocket/Frame;)Z", "Lkotlinx/serialization/KSerializer;", "serializer", "serializeContent", "(Lkotlinx/serialization/KSerializer;Lkotlinx/serialization/SerialFormat;Ljava/lang/Object;)Lio/ktor/websocket/Frame;", "Lkotlinx/serialization/SerialFormat;", "ktor-serialization-kotlinx"})
public final class KotlinxWebsocketSerializationConverter
implements WebsocketContentConverter {
    private final SerialFormat format;

    public KotlinxWebsocketSerializationConverter(SerialFormat object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.format = object;
        if (!(this.format instanceof BinaryFormat || this.format instanceof StringFormat)) {
            object = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw new IllegalArgumentException(object.toString());
        }
    }

    public final Object serialize(Charset object, TypeInfo typeInfo, Object object2, Continuation<? super Frame> continuation) {
        try {
            object = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        }
        catch (SerializationException serializationException) {
            object = SerializerLookupKt.guessSerializer(object2, this.format.getSerializersModule());
        }
        return this.serializeContent((KSerializer<?>)object, this.format, object2);
    }

    public final Object deserialize(Charset kSerializer, TypeInfo typeInfo, Frame frame, Continuation<Object> continuation) {
        if (!this.isApplicable(frame)) {
            throw new WebsocketConverterNotFoundException("Unsupported frame " + frame.getFrameType().name(), null, 2, null);
        }
        kSerializer = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        typeInfo = this.format;
        if (typeInfo instanceof StringFormat) {
            if (frame instanceof Frame.Text) {
                return ((StringFormat)this.format).decodeFromString((DeserializationStrategy)kSerializer, FrameCommonKt.readText((Frame.Text)((Frame.Text)frame)));
            }
            throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + frame.getFrameType().name(), null, frame, 2, null);
        }
        if (typeInfo instanceof BinaryFormat) {
            if (frame instanceof Frame.Binary) {
                return ((BinaryFormat)this.format).decodeFromByteArray((DeserializationStrategy)kSerializer, FrameCommonKt.readBytes((Frame)frame));
            }
            throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + frame.getFrameType().name(), null, frame, 2, null);
        }
        throw new IllegalStateException(("Unsupported format " + this.format).toString());
    }

    public final boolean isApplicable(Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"");
        return frame instanceof Frame.Text || frame instanceof Frame.Binary;
    }

    private final Frame serializeContent(KSerializer<?> object, SerialFormat serialFormat, Object object2) {
        SerialFormat serialFormat2 = serialFormat;
        if (serialFormat2 instanceof StringFormat) {
            StringFormat stringFormat = (StringFormat)serialFormat;
            Intrinsics.checkNotNull(object);
            object = stringFormat.encodeToString((SerializationStrategy)object, object2);
            return (Frame)new Frame.Text(object);
        }
        if (serialFormat2 instanceof BinaryFormat) {
            BinaryFormat binaryFormat = (BinaryFormat)serialFormat;
            Intrinsics.checkNotNull(object);
            object = binaryFormat.encodeToByteArray((SerializationStrategy)object, object2);
            return (Frame)new Frame.Binary(true, object);
        }
        throw new IllegalStateException(("Unsupported format " + serialFormat).toString());
    }
}

