/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.kqueue.AcceptFilter;
import io.netty.channel.kqueue.KQueueChannelOption;
import io.netty.channel.kqueue.KQueueServerChannelConfig;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import java.io.IOException;
import java.util.Map;

public class KQueueServerSocketChannelConfig
extends KQueueServerChannelConfig {
    KQueueServerSocketChannelConfig(KQueueServerSocketChannel kQueueServerSocketChannel) {
        super(kQueueServerSocketChannel);
        this.setReuseAddress(true);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        KQueueServerSocketChannelConfig kQueueServerSocketChannelConfig = this;
        return kQueueServerSocketChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{UnixChannelOption.SO_REUSEPORT, KQueueChannelOption.SO_ACCEPTFILTER});
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == UnixChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        if (channelOption == KQueueChannelOption.SO_ACCEPTFILTER) {
            return (T)this.getAcceptFilter();
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t) {
        this.validate(channelOption, t);
        if (channelOption == UnixChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)t);
        } else if (channelOption == KQueueChannelOption.SO_ACCEPTFILTER) {
            this.setAcceptFilter((AcceptFilter)t);
        } else {
            return super.setOption(channelOption, t);
        }
        return true;
    }

    public KQueueServerSocketChannelConfig setReusePort(boolean bl) {
        try {
            ((KQueueServerSocketChannel)this.channel).socket.setReusePort(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public boolean isReusePort() {
        try {
            return ((KQueueServerSocketChannel)this.channel).socket.isReusePort();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public KQueueServerSocketChannelConfig setAcceptFilter(AcceptFilter acceptFilter) {
        try {
            ((KQueueServerSocketChannel)this.channel).socket.setAcceptFilter(acceptFilter);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    public AcceptFilter getAcceptFilter() {
        try {
            return ((KQueueServerSocketChannel)this.channel).socket.getAcceptFilter();
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    @Override
    public KQueueServerSocketChannelConfig setRcvAllocTransportProvidesGuess(boolean bl) {
        super.setRcvAllocTransportProvidesGuess(bl);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setReuseAddress(boolean bl) {
        super.setReuseAddress(bl);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setReceiveBufferSize(int n) {
        super.setReceiveBufferSize(n);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setPerformancePreferences(int n, int n2, int n3) {
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setBacklog(int n) {
        super.setBacklog(n);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setTcpFastOpen(boolean bl) {
        super.setTcpFastOpen(bl);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Override
    @Deprecated
    public KQueueServerSocketChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    @Deprecated
    public KQueueServerSocketChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Override
    @Deprecated
    public KQueueServerSocketChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public KQueueServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }
}

