/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.AttributeKey;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.WebSocketDeflateExtensionKt;
import io.ktor.websocket.WebSocketExtension;
import io.ktor.websocket.WebSocketExtensionFactory;
import io.ktor.websocket.WebSocketExtensionHeader;
import io.ktor.websocket.internals.DeflaterUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002/.B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R.\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00158\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\t8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\t8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010%\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u0016\u0010-\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010%\u00a8\u00060"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension;", "Lio/ktor/websocket/WebSocketExtension;", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "config", "<init>", "(Lio/ktor/websocket/WebSocketDeflateExtension$Config;)V", "", "Lio/ktor/websocket/WebSocketExtensionHeader;", "negotiatedProtocols", "", "clientNegotiation", "(Ljava/util/List;)Z", "requestedProtocols", "serverNegotiation", "(Ljava/util/List;)Ljava/util/List;", "Lio/ktor/websocket/Frame;", "frame", "processOutgoingFrame", "(Lio/ktor/websocket/Frame;)Lio/ktor/websocket/Frame;", "processIncomingFrame", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "Lio/ktor/websocket/WebSocketExtensionFactory;", "factory", "Lio/ktor/websocket/WebSocketExtensionFactory;", "getFactory", "()Lio/ktor/websocket/WebSocketExtensionFactory;", "protocols", "Ljava/util/List;", "getProtocols", "()Ljava/util/List;", "Ljava/util/zip/Inflater;", "inflater", "Ljava/util/zip/Inflater;", "Ljava/util/zip/Deflater;", "deflater", "Ljava/util/zip/Deflater;", "outgoingNoContextTakeover", "Z", "getOutgoingNoContextTakeover$ktor_websockets", "()Z", "setOutgoingNoContextTakeover$ktor_websockets", "(Z)V", "incomingNoContextTakeover", "getIncomingNoContextTakeover$ktor_websockets", "setIncomingNoContextTakeover$ktor_websockets", "decompressIncoming", "Companion", "Config", "ktor-websockets"})
public final class WebSocketDeflateExtension
implements WebSocketExtension<Config> {
    public static final Companion Companion;
    private final Config config;
    private final WebSocketExtensionFactory<Config, ? extends WebSocketExtension<Config>> factory;
    private final List<WebSocketExtensionHeader> protocols;
    private final Inflater inflater;
    private final Deflater deflater;
    private boolean outgoingNoContextTakeover;
    private boolean incomingNoContextTakeover;
    private boolean decompressIncoming;
    private static final AttributeKey<WebSocketDeflateExtension> key;
    private static final boolean rsv1;
    private static final boolean rsv2;
    private static final boolean rsv3;

    public WebSocketDeflateExtension(Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"");
        this.config = config;
        this.factory = Companion;
        this.protocols = this.config.build$ktor_websockets();
        this.inflater = new Inflater(true);
        this.deflater = new Deflater(this.config.getCompressionLevel(), true);
    }

    @Override
    public final WebSocketExtensionFactory<Config, ? extends WebSocketExtension<Config>> getFactory() {
        return this.factory;
    }

    @Override
    public final List<WebSocketExtensionHeader> getProtocols() {
        return this.protocols;
    }

    public final boolean getOutgoingNoContextTakeover$ktor_websockets() {
        return this.outgoingNoContextTakeover;
    }

    public final void setOutgoingNoContextTakeover$ktor_websockets(boolean bl) {
        this.outgoingNoContextTakeover = bl;
    }

    public final boolean getIncomingNoContextTakeover$ktor_websockets() {
        return this.incomingNoContextTakeover;
    }

    public final void setIncomingNoContextTakeover$ktor_websockets(boolean bl) {
        this.incomingNoContextTakeover = bl;
    }

    @Override
    public final boolean clientNegotiation(List<WebSocketExtensionHeader> object) {
        Iterable iterable;
        Object object2;
        Object object3;
        block21: {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object3 = (Iterable)object;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object3 = object2.next();
                object = (WebSocketExtensionHeader)object3;
                if (!Intrinsics.areEqual((Object)((WebSocketExtensionHeader)object).getName(), (Object)"permessage-deflate")) continue;
                iterable = object3;
                break block21;
            }
            iterable = null;
        }
        WebSocketExtensionHeader webSocketExtensionHeader = (WebSocketExtensionHeader)((Object)iterable);
        if (webSocketExtensionHeader == null) {
            return false;
        }
        object = webSocketExtensionHeader;
        this.incomingNoContextTakeover = this.config.getServerNoContextTakeOver();
        this.outgoingNoContextTakeover = this.config.getClientNoContextTakeOver();
        object = ((WebSocketExtensionHeader)object).parseParameters().iterator();
        while (object.hasNext()) {
            object2 = (Pair)object.next();
            object3 = (String)object2.component1();
            object2 = (String)object2.component2();
            int n2 = -1;
            switch (((String)object3).hashCode()) {
                case 646404390: {
                    if (((String)object3).equals("client_max_window_bits")) {
                        n2 = 1;
                    }
                    break;
                }
                case -708713803: {
                    if (((String)object3).equals("client_no_context_takeover")) {
                        n2 = 2;
                    }
                    break;
                }
                case 1266201133: {
                    if (((String)object3).equals("server_no_context_takeover")) {
                        n2 = 3;
                    }
                    break;
                }
                case 2034279582: {
                    if (((String)object3).equals("server_max_window_bits")) {
                        n2 = 4;
                    }
                    break;
                }
            }
            switch (n2) {
                case 4: {
                    break;
                }
                case 1: {
                    if (StringsKt.isBlank((CharSequence)((CharSequence)object2)) || Integer.parseInt((String)object2) == 15) break;
                    object = "Only 15 window size is supported.";
                    throw new IllegalStateException(object.toString());
                }
                case 3: {
                    if (!StringsKt.isBlank((CharSequence)((CharSequence)object2))) {
                        object = "WebSocket permessage-deflate extension parameter server_no_context_takeover shouldn't have a value. Current: " + (String)object2;
                        throw new IllegalStateException(object.toString());
                    }
                    this.incomingNoContextTakeover = true;
                    break;
                }
                case 2: {
                    if (!StringsKt.isBlank((CharSequence)((CharSequence)object2))) {
                        object = "WebSocket permessage-deflate extension parameter client_no_context_takeover shouldn't have a value. Current: " + (String)object2;
                        throw new IllegalStateException(object.toString());
                    }
                    this.outgoingNoContextTakeover = true;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final List<WebSocketExtensionHeader> serverNegotiation(List<WebSocketExtensionHeader> object) {
        Iterable iterable;
        Object object2;
        Object object3;
        Object object4;
        block12: {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            object4 = (Iterable)object;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object4 = object3.next();
                object2 = (WebSocketExtensionHeader)object4;
                if (!Intrinsics.areEqual((Object)((WebSocketExtensionHeader)object2).getName(), (Object)"permessage-deflate")) continue;
                iterable = object4;
                break block12;
            }
            iterable = null;
        }
        WebSocketExtensionHeader webSocketExtensionHeader = (WebSocketExtensionHeader)((Object)iterable);
        if (webSocketExtensionHeader == null) {
            return CollectionsKt.emptyList();
        }
        object = webSocketExtensionHeader;
        List list = new ArrayList();
        object = ((WebSocketExtensionHeader)object).parseParameters().iterator();
        block7: while (object.hasNext()) {
            block13: {
                object4 = (Pair)object.next();
                object3 = (String)object4.component1();
                object4 = (String)object4.component2();
                object2 = object3;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                String string = ((String)object2).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                object2 = string;
                switch (string.hashCode()) {
                    case 646404390: {
                        if (((String)object2).equals("client_max_window_bits")) continue block7;
                        throw new IllegalStateException(("Unsupported extension parameter: (" + (String)object3 + ", " + (String)object4 + ')').toString());
                    }
                    case -708713803: {
                        if (!((String)object2).equals("client_no_context_takeover")) {
                            throw new IllegalStateException(("Unsupported extension parameter: (" + (String)object3 + ", " + (String)object4 + ')').toString());
                        }
                        break block13;
                    }
                    case 1266201133: {
                        if (((String)object2).equals("server_no_context_takeover")) break;
                        throw new IllegalStateException(("Unsupported extension parameter: (" + (String)object3 + ", " + (String)object4 + ')').toString());
                    }
                    case 2034279582: {
                        if (!((String)object2).equals("server_max_window_bits")) throw new IllegalStateException(("Unsupported extension parameter: (" + (String)object3 + ", " + (String)object4 + ')').toString());
                        if (Integer.parseInt((String)object4) == 15) continue block7;
                        object = "Only 15 window size is supported";
                        throw new IllegalStateException(object.toString());
                    }
                }
                if (!StringsKt.isBlank((CharSequence)((CharSequence)object4))) {
                    throw new IllegalStateException("Check failed.");
                }
                this.outgoingNoContextTakeover = true;
                list.add("server_no_context_takeover");
                continue;
            }
            if (!StringsKt.isBlank((CharSequence)((CharSequence)object4))) {
                throw new IllegalStateException("Check failed.");
            }
            this.incomingNoContextTakeover = true;
            list.add("client_no_context_takeover");
            continue;
            throw new IllegalStateException(("Unsupported extension parameter: (" + (String)object3 + ", " + (String)object4 + ')').toString());
        }
        return CollectionsKt.listOf((Object)new WebSocketExtensionHeader("permessage-deflate", list));
    }

    @Override
    public final Frame processOutgoingFrame(Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"");
        if (!(frame instanceof Frame.Text) && !(frame instanceof Frame.Binary)) {
            return frame;
        }
        if (!((Boolean)this.config.getCompressCondition$ktor_websockets().invoke((Object)frame)).booleanValue()) {
            return frame;
        }
        byte[] byArray = DeflaterUtilsKt.deflateFully(this.deflater, frame.getData());
        if (this.outgoingNoContextTakeover) {
            this.deflater.reset();
        }
        return Frame.Companion.byType(frame.getFin(), frame.getFrameType(), byArray, rsv1, frame.getRsv2(), frame.getRsv3());
    }

    @Override
    public final Frame processIncomingFrame(Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"");
        if (!WebSocketDeflateExtensionKt.access$isCompressed(frame) && !this.decompressIncoming) {
            return frame;
        }
        this.decompressIncoming = true;
        byte[] byArray = DeflaterUtilsKt.inflateFully(this.inflater, frame.getData());
        if (this.incomingNoContextTakeover) {
            this.inflater.reset();
        }
        if (frame.getFin()) {
            this.decompressIncoming = false;
        }
        return Frame.Companion.byType(frame.getFin(), frame.getFrameType(), byArray, !rsv1, frame.getRsv2(), frame.getRsv3());
    }

    static {
        KType kType;
        Companion = new Companion(null);
        String string = "WebsocketDeflateExtension";
        string = "WebsocketDeflateExtension";
        Object object = Reflection.getOrCreateKotlinClass(WebSocketDeflateExtension.class);
        try {
            kType = Reflection.typeOf(WebSocketDeflateExtension.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KClass kClass = object;
        object = kType;
        kType = kClass;
        string = new TypeInfo((KClass)kType, (KType)object);
        object = string;
        key = new AttributeKey((String)object, (TypeInfo)string);
        rsv1 = true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u00032\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension$Companion;", "Lio/ktor/websocket/WebSocketExtensionFactory;", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "Lio/ktor/websocket/WebSocketDeflateExtension;", "<init>", "()V", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "config", "install", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/websocket/WebSocketDeflateExtension;", "Lio/ktor/util/AttributeKey;", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "", "rsv1", "Z", "getRsv1", "()Z", "rsv2", "getRsv2", "rsv3", "getRsv3", "ktor-websockets"})
    public static final class Companion
    implements WebSocketExtensionFactory<Config, WebSocketDeflateExtension> {
        private Companion() {
        }

        @Override
        public final AttributeKey<WebSocketDeflateExtension> getKey() {
            return key;
        }

        @Override
        public final boolean getRsv1() {
            return rsv1;
        }

        @Override
        public final boolean getRsv2() {
            return rsv2;
        }

        @Override
        public final boolean getRsv3() {
            return rsv3;
        }

        @Override
        public final WebSocketDeflateExtension install(Function1<? super Config, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Config config = new Config();
            function1.invoke((Object)config);
            return new WebSocketDeflateExtension(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u001a\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\f\u001a\u00020\n2'\u0010\u000b\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\u0004\b\f\u0010\rJ0\u0010\u0011\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0004\u00a2\u0006\u0004\b\u0011\u0010\rJ\u0015\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u001b\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\"\u0010#\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0015R4\u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\n0\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010\rR.\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010)\u001a\u0004\b.\u0010+\"\u0004\b/\u0010\r\u00a8\u00060"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "", "<init>", "()V", "Lkotlin/Function1;", "", "Lio/ktor/websocket/WebSocketExtensionHeader;", "Lkotlin/ParameterName;", "name", "protocols", "", "block", "configureProtocols", "(Lkotlin/jvm/functions/Function1;)V", "Lio/ktor/websocket/Frame;", "frame", "", "compressIf", "", "bytes", "compressIfBiggerThan", "(I)V", "", "build$ktor_websockets", "()Ljava/util/List;", "build", "clientNoContextTakeOver", "Z", "getClientNoContextTakeOver", "()Z", "setClientNoContextTakeOver", "(Z)V", "serverNoContextTakeOver", "getServerNoContextTakeOver", "setServerNoContextTakeOver", "compressionLevel", "I", "getCompressionLevel", "()I", "setCompressionLevel", "manualConfig", "Lkotlin/jvm/functions/Function1;", "getManualConfig$ktor_websockets", "()Lkotlin/jvm/functions/Function1;", "setManualConfig$ktor_websockets", "compressCondition", "getCompressCondition$ktor_websockets", "setCompressCondition$ktor_websockets", "ktor-websockets"})
    public static final class Config {
        private boolean clientNoContextTakeOver;
        private boolean serverNoContextTakeOver;
        private int compressionLevel = -1;
        private Function1<? super List<WebSocketExtensionHeader>, Unit> manualConfig = Config::manualConfig$lambda$0;
        private Function1<? super Frame, Boolean> compressCondition = Config::compressCondition$lambda$1;

        public final boolean getClientNoContextTakeOver() {
            return this.clientNoContextTakeOver;
        }

        public final void setClientNoContextTakeOver(boolean bl) {
            this.clientNoContextTakeOver = bl;
        }

        public final boolean getServerNoContextTakeOver() {
            return this.serverNoContextTakeOver;
        }

        public final void setServerNoContextTakeOver(boolean bl) {
            this.serverNoContextTakeOver = bl;
        }

        public final int getCompressionLevel() {
            return this.compressionLevel;
        }

        public final void setCompressionLevel(int n2) {
            this.compressionLevel = n2;
        }

        public final Function1<List<WebSocketExtensionHeader>, Unit> getManualConfig$ktor_websockets() {
            return this.manualConfig;
        }

        public final void setManualConfig$ktor_websockets(Function1<? super List<WebSocketExtensionHeader>, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            this.manualConfig = function1;
        }

        public final Function1<Frame, Boolean> getCompressCondition$ktor_websockets() {
            return this.compressCondition;
        }

        public final void setCompressCondition$ktor_websockets(Function1<? super Frame, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            this.compressCondition = function1;
        }

        public final void configureProtocols(Function1<? super List<WebSocketExtensionHeader>, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Function1<? super List<WebSocketExtensionHeader>, Unit> function12 = this.manualConfig;
            this.manualConfig = arg_0 -> Config.configureProtocols$lambda$2(function12, function1, arg_0);
        }

        public final void compressIf(Function1<? super Frame, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Function1<? super Frame, Boolean> function12 = this.compressCondition;
            this.compressCondition = arg_0 -> Config.compressIf$lambda$3(function1, function12, arg_0);
        }

        public final void compressIfBiggerThan(int n2) {
            this.compressIf((Function1<? super Frame, Boolean>)((Function1)arg_0 -> Config.compressIfBiggerThan$lambda$4(n2, arg_0)));
        }

        public final List<WebSocketExtensionHeader> build$ktor_websockets() {
            List list = new ArrayList();
            List list2 = new ArrayList();
            if (this.clientNoContextTakeOver) {
                ((Collection)list2).add("client_no_context_takeover");
            }
            if (this.serverNoContextTakeOver) {
                ((Collection)list2).add("server_no_context_takeover");
            }
            ((Collection)list).add(new WebSocketExtensionHeader("permessage-deflate", list2));
            this.manualConfig.invoke((Object)list);
            return list;
        }

        private static final Unit manualConfig$lambda$0(List list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"");
            return Unit.INSTANCE;
        }

        private static final boolean compressCondition$lambda$1(Frame frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"");
            return true;
        }

        private static final Unit configureProtocols$lambda$2(Function1 function1, Function1 function12, List list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"");
            function1.invoke((Object)list);
            function12.invoke((Object)list);
            return Unit.INSTANCE;
        }

        private static final boolean compressIf$lambda$3(Function1 function1, Function1 function12, Frame frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"");
            return (Boolean)function1.invoke((Object)frame) != false && (Boolean)function12.invoke((Object)frame) != false;
        }

        private static final boolean compressIfBiggerThan$lambda$4(int n2, Frame frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"");
            return frame.getData().length > n2;
        }
    }
}

