/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainNameMapping;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@Deprecated
public final class DomainNameMappingBuilder<V> {
    private final V defaultValue;
    private final Map<String, V> map;

    public DomainNameMappingBuilder(V v) {
        this(4, v);
    }

    public DomainNameMappingBuilder(int n, V v) {
        this.defaultValue = ObjectUtil.checkNotNull(v, "defaultValue");
        this.map = new LinkedHashMap<String, V>(n);
    }

    public final DomainNameMappingBuilder<V> add(String string, V v) {
        this.map.put(ObjectUtil.checkNotNull(string, "hostname"), ObjectUtil.checkNotNull(v, "output"));
        return this;
    }

    public final DomainNameMapping<V> build() {
        return new ImmutableDomainNameMapping(this.defaultValue, this.map);
    }

    private static final class ImmutableDomainNameMapping<V>
    extends DomainNameMapping<V> {
        private static final String REPR_HEADER = "ImmutableDomainNameMapping(default: ";
        private static final String REPR_MAP_OPENING = ", map: {";
        private static final String REPR_MAP_CLOSING = "})";
        private static final int REPR_CONST_PART_LENGTH = 36 + 8 + 2;
        private final String[] domainNamePatterns;
        private final V[] values;
        private final Map<String, V> map;

        private ImmutableDomainNameMapping(V object, Map<String, V> map) {
            super(null, object);
            object = map.entrySet();
            int n = object.size();
            this.domainNamePatterns = new String[n];
            this.values = new Object[n];
            map = new LinkedHashMap<String, V>(map.size());
            n = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string = ImmutableDomainNameMapping.normalizeHostname((String)entry.getKey());
                entry = entry.getValue();
                this.domainNamePatterns[n] = string;
                this.values[n] = entry;
                map.put(string, entry);
                ++n;
            }
            this.map = Collections.unmodifiableMap(map);
        }

        @Override
        @Deprecated
        public final DomainNameMapping<V> add(String string, V v) {
            throw new UnsupportedOperationException("Immutable DomainNameMapping does not support modification after initial creation");
        }

        @Override
        public final V map(String string) {
            if (string != null) {
                string = ImmutableDomainNameMapping.normalizeHostname(string);
                int n = this.domainNamePatterns.length;
                for (int i = 0; i < n; ++i) {
                    if (!ImmutableDomainNameMapping.matches(this.domainNamePatterns[i], string)) continue;
                    return this.values[i];
                }
            }
            return this.defaultValue;
        }

        @Override
        public final Map<String, V> asMap() {
            return this.map;
        }

        @Override
        public final String toString() {
            CharSequence charSequence = this.defaultValue.toString();
            int n = this.domainNamePatterns.length;
            if (n == 0) {
                return REPR_HEADER + (String)charSequence + ", map: {})";
            }
            String string = this.domainNamePatterns[0];
            String string2 = this.values[0].toString();
            int n2 = string.length() + string2.length() + 3;
            n2 = ImmutableDomainNameMapping.estimateBufferSize(((String)charSequence).length(), n, n2);
            charSequence = new StringBuilder(n2).append(REPR_HEADER).append((String)charSequence).append(REPR_MAP_OPENING);
            ImmutableDomainNameMapping.appendMapping((StringBuilder)charSequence, string, string2);
            for (int i = 1; i < n; ++i) {
                ((StringBuilder)charSequence).append(", ");
                this.appendMapping((StringBuilder)charSequence, i);
            }
            return ((StringBuilder)charSequence).append(REPR_MAP_CLOSING).toString();
        }

        private static int estimateBufferSize(int n, int n2, int n3) {
            return REPR_CONST_PART_LENGTH + n + (int)((double)(n3 * n2) * 1.1);
        }

        private StringBuilder appendMapping(StringBuilder stringBuilder, int n) {
            return ImmutableDomainNameMapping.appendMapping(stringBuilder, this.domainNamePatterns[n], this.values[n].toString());
        }

        private static StringBuilder appendMapping(StringBuilder stringBuilder, String string, String string2) {
            return stringBuilder.append(string).append('=').append(string2);
        }
    }
}

