/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class RejectedExecutionHandlers {
    private static final RejectedExecutionHandler REJECT = new RejectedExecutionHandler(){

        @Override
        public final void rejected(Runnable runnable, SingleThreadEventExecutor singleThreadEventExecutor) {
            throw new RejectedExecutionException();
        }
    };

    private RejectedExecutionHandlers() {
    }

    public static RejectedExecutionHandler reject() {
        return REJECT;
    }

    public static RejectedExecutionHandler backoff(final int n, long l, TimeUnit timeUnit) {
        ObjectUtil.checkPositive(n, "retries");
        final long l2 = timeUnit.toNanos(l);
        return new RejectedExecutionHandler(){

            @Override
            public final void rejected(Runnable runnable, SingleThreadEventExecutor singleThreadEventExecutor) {
                if (!singleThreadEventExecutor.inEventLoop()) {
                    for (int i = 0; i < n; ++i) {
                        singleThreadEventExecutor.wakeup(false);
                        LockSupport.parkNanos(l2);
                        if (!singleThreadEventExecutor.offerTask(runnable)) continue;
                        return;
                    }
                }
                throw new RejectedExecutionException();
            }
        };
    }
}

