/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;

public abstract class AbstractInternalLogger
implements InternalLogger,
Serializable {
    private static final long serialVersionUID = -6382972526573193470L;
    static final String EXCEPTION_MESSAGE = "Unexpected exception:";
    private final String name;

    protected AbstractInternalLogger(String string) {
        this.name = ObjectUtil.checkNotNull(string, "name");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEnabled(InternalLogLevel internalLogLevel) {
        switch (internalLogLevel) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    @Override
    public void trace(Throwable throwable) {
        this.trace(EXCEPTION_MESSAGE, throwable);
    }

    @Override
    public void debug(Throwable throwable) {
        this.debug(EXCEPTION_MESSAGE, throwable);
    }

    @Override
    public void info(Throwable throwable) {
        this.info(EXCEPTION_MESSAGE, throwable);
    }

    @Override
    public void warn(Throwable throwable) {
        this.warn(EXCEPTION_MESSAGE, throwable);
    }

    @Override
    public void error(Throwable throwable) {
        this.error(EXCEPTION_MESSAGE, throwable);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Throwable throwable) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, throwable);
                return;
            }
            case DEBUG: {
                this.debug(string, throwable);
                return;
            }
            case INFO: {
                this.info(string, throwable);
                return;
            }
            case WARN: {
                this.warn(string, throwable);
                return;
            }
            case ERROR: {
                this.error(string, throwable);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, Throwable throwable) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(throwable);
                return;
            }
            case DEBUG: {
                this.debug(throwable);
                return;
            }
            case INFO: {
                this.info(throwable);
                return;
            }
            case WARN: {
                this.warn(throwable);
                return;
            }
            case ERROR: {
                this.error(throwable);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string);
                return;
            }
            case DEBUG: {
                this.debug(string);
                return;
            }
            case INFO: {
                this.info(string);
                return;
            }
            case WARN: {
                this.warn(string);
                return;
            }
            case ERROR: {
                this.error(string);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object object) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, object);
                return;
            }
            case DEBUG: {
                this.debug(string, object);
                return;
            }
            case INFO: {
                this.info(string, object);
                return;
            }
            case WARN: {
                this.warn(string, object);
                return;
            }
            case ERROR: {
                this.error(string, object);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object object, Object object2) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, object, object2);
                return;
            }
            case DEBUG: {
                this.debug(string, object, object2);
                return;
            }
            case INFO: {
                this.info(string, object, object2);
                return;
            }
            case WARN: {
                this.warn(string, object, object2);
                return;
            }
            case ERROR: {
                this.error(string, object, object2);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object ... objectArray) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, objectArray);
                return;
            }
            case DEBUG: {
                this.debug(string, objectArray);
                return;
            }
            case INFO: {
                this.info(string, objectArray);
                return;
            }
            case WARN: {
                this.warn(string, objectArray);
                return;
            }
            case ERROR: {
                this.error(string, objectArray);
                return;
            }
        }
        throw new Error();
    }

    protected Object readResolve() {
        return InternalLoggerFactory.getInstance(this.name());
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

