/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

public class OutputStreamAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected Encoder<E> encoder;
    protected final ReentrantLock streamWriteLock = new ReentrantLock(false);
    private OutputStream outputStream;
    boolean immediateFlush = true;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void start() {
        int n = 0;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", this));
            ++n;
        }
        if (this.outputStream == null) {
            this.addStatus(new ErrorStatus("No output stream set for the appender named \"" + this.name + "\".", this));
            ++n;
        }
        if (n == 0) {
            super.start();
        }
    }

    public void setLayout(Layout<E> layout) {
        this.addWarn("This appender no longer admits a layout as a sub-component, set an encoder instead.");
        this.addWarn("To ensure compatibility, wrapping your layout in LayoutWrappingEncoder.");
        this.addWarn("See also http://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        LayoutWrappingEncoder<E> layoutWrappingEncoder = new LayoutWrappingEncoder<E>();
        layoutWrappingEncoder.setLayout(layout);
        layoutWrappingEncoder.setContext(this.context);
        this.encoder = layoutWrappingEncoder;
    }

    @Override
    protected void append(E e) {
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(e);
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            this.closeOutputStream();
            super.stop();
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    protected void closeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.encoderClose();
                this.outputStream.close();
                this.outputStream = null;
                return;
            }
            catch (IOException iOException) {
                this.addStatus(new ErrorStatus("Could not close output stream for OutputStreamAppender.", this, iOException));
            }
        }
    }

    void encoderClose() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] byArray = this.encoder.footerBytes();
                this.writeBytes(byArray);
                return;
            }
            catch (IOException iOException) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", this, iOException));
            }
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.streamWriteLock.lock();
        try {
            this.closeOutputStream();
            this.outputStream = outputStream;
            if (this.encoder == null) {
                this.addWarn("Encoder has not been set. Cannot invoke its init method.");
                return;
            }
            this.encoderInit();
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    void encoderInit() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] byArray = this.encoder.headerBytes();
                this.writeBytes(byArray);
                return;
            }
            catch (IOException iOException) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to initialize encoder for appender named [" + this.name + "].", this, iOException));
            }
        }
    }

    protected void writeOut(E object) {
        object = this.encoder.encode(object);
        this.writeBytes((byte[])object);
    }

    private void writeBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            this.writeByteArrayToOutputStreamWithPossibleFlush(byArray);
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    protected final void writeByteArrayToOutputStreamWithPossibleFlush(byte[] byArray) {
        this.outputStream.write(byArray);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    protected void subAppend(E e) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (e instanceof DeferredProcessingAware) {
                ((DeferredProcessingAware)e).prepareForDeferredProcessing();
            }
            this.writeOut(e);
            return;
        }
        catch (IOException iOException) {
            this.started = false;
            this.addStatus(new ErrorStatus("IO failure in appender", this, iOException));
            return;
        }
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean bl) {
        this.immediateFlush = bl;
    }
}

