/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

public class JsonEscapeUtil {
    protected static final char[] HEXADECIMALS_TABLE = "0123456789ABCDEF".toCharArray();
    static final int ESCAPE_CODES_COUNT = 32;
    static final String[] ESCAPE_CODES = new String[32];

    private static String _computeEscapeCodeBelowASCII32(char c) {
        if (c > ' ') {
            throw new IllegalArgumentException("input must be less than 32");
        }
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("\\u00");
        int n = c >> 4;
        stringBuilder.append(HEXADECIMALS_TABLE[n]);
        c = (char)(c & 0xF);
        stringBuilder.append(HEXADECIMALS_TABLE[c]);
        return stringBuilder.toString();
    }

    static String getObligatoryEscapeCode(char c) {
        if (c < ' ') {
            return ESCAPE_CODES[c];
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\/";
        }
        return null;
    }

    public static String jsonEscapeString(String string) {
        int n = string.length();
        int n2 = (int)((double)n * 1.1);
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = JsonEscapeUtil.getObligatoryEscapeCode(c);
            if (string2 == null) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    static {
        block7: for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            switch (c) {
                case '\b': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\b";
                    continue block7;
                }
                case '\t': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\t";
                    continue block7;
                }
                case '\n': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\n";
                    continue block7;
                }
                case '\f': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\f";
                    continue block7;
                }
                case '\r': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\r";
                    continue block7;
                }
                default: {
                    char c2 = c;
                    JsonEscapeUtil.ESCAPE_CODES[c2] = JsonEscapeUtil._computeEscapeCodeBelowASCII32(c2);
                }
            }
        }
    }
}

