/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Model
implements Serializable {
    private static final long serialVersionUID = -797372668713068159L;
    boolean handled = false;
    boolean skipped = false;
    String tag;
    String bodyText;
    int lineNumber;
    List<Model> subModels = new ArrayList<Model>();

    public static Model duplicate(Model object) {
        Model model = ((Model)object).makeNewInstance();
        model.mirror((Model)object);
        for (Model model2 : ((Model)object).subModels) {
            model2 = Model.duplicate(model2);
            model.subModels.add(model2);
        }
        return model;
    }

    protected Model makeNewInstance() {
        return new Model();
    }

    protected void mirror(Model model) {
        this.tag = model.tag;
        this.bodyText = model.bodyText;
        this.lineNumber = model.lineNumber;
    }

    public void markAsSkipped() {
        this.skipped = true;
    }

    public void deepMarkAsSkipped() {
        this.markAsSkipped();
        for (Model model : this.getSubModels()) {
            model.deepMarkAsSkipped();
        }
    }

    void resetForReuse() {
        this.handled = false;
        this.skipped = false;
        for (Model model : this.subModels) {
            model.resetForReuse();
        }
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isUnhandled() {
        return !this.handled;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void markAsHandled() {
        this.handled = true;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    public void addSubModel(Model model) {
        this.subModels.add(model);
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void addText(String string) {
        if (this.bodyText == null) {
            this.bodyText = string;
            return;
        }
        this.bodyText = this.bodyText + string;
    }

    public String idString() {
        return "<" + this.tag + "> at line " + this.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.bodyText, this.lineNumber, this.subModels, this.tag);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Model)object;
        return Objects.equals(this.bodyText, ((Model)object).bodyText) && this.lineNumber == ((Model)object).lineNumber && Objects.equals(this.subModels, ((Model)object).subModels) && Objects.equals(this.tag, ((Model)object).tag);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [tag=" + this.tag + ", bodyText=" + this.bodyText + ", id=" + this.hashCode() + "]";
    }
}

