/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.Sys;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001mB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ\u0016\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019J/\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010%J/\u0010!\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0013J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013J\u0016\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013J'\u0010-\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010.J'\u0010-\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00132\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0019J\u0018\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013J\u0018\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0013J\u0018\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013J\u0018\u00109\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0013J\u0018\u00109\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013J\u0010\u0010:\u001a\u0004\u0018\u00010\u00132\u0006\u0010;\u001a\u00020\u0013J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0013J\u000e\u0010=\u001a\u00020\u00042\u0006\u0010*\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020\u0019J\u000e\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020\u0013J/\u0010A\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00192\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010%J/\u0010A\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010(J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0013J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010D\u001a\u00020\u0019J-\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010D\u001a\u00020\u00192\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010FJ\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010D\u001a\u00020\u0013J'\u0010G\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010I\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010I\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010J\u001a\u00020KJ\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u0004J\u001a\u0010I\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010M\u001a\u00060Nj\u0002`OJ$\u0010I\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010P\u001a\u00060Nj\u0002`O2\b\u0010Q\u001a\u0004\u0018\u00010\u0013J\u0010\u0010I\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010R\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010S\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010*\u001a\u00020UJ\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00130W2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00130W2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u0004J$\u0010V\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00130Z2\u0006\u0010X\u001a\u00020\u0004J\u0016\u0010[\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010]\u001a\u00020\u00132\u0006\u0010^\u001a\u00020\u0013J\u000e\u0010_\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0013J\u000e\u0010`\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010b\u001a\u00020cJ\u000e\u0010a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013J \u0010d\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004H\u0002J \u0010g\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004H\u0002J\u0016\u0010j\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010e\u001a\u00020\u0019J\u0016\u0010j\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u0019J\u0016\u0010j\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u0013J\u0016\u0010j\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00132\u0006\u0010e\u001a\u00020\u0013J\u001e\u0010k\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004J\u001e\u0010k\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004J\u001e\u0010k\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00132\u0006\u0010e\u001a\u00020\u00132\u0006\u0010f\u001a\u00020\u0004J'\u0010l\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010l\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006n"}, d2={"Ldorkbox/util/FileUtil;", "", "()V", "DEBUG", "", "OTHER_SEPARATOR", "", "SYSTEM_SEPARATOR", "UNIX_SEPARATOR", "WINDOWS_SEPARATOR", "ZIP_HEADER", "", "getZIP_HEADER", "()[B", "setZIP_HEADER", "([B)V", "log", "Lorg/slf4j/Logger;", "version", "", "getVersion", "()Ljava/lang/String;", "append", "", "file", "Ljava/io/File;", "text", "", "(Ljava/io/File;[Ljava/lang/String;)V", "", "concatFiles", "one", "two", "copyDirectory", "src_", "dest_", "namesToIgnore", "(Ljava/io/File;Ljava/io/File;[Ljava/lang/String;)V", "src", "dest", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "copyFile", "in", "out", "copyFileToDir", "delete", "(Ljava/io/File;[Ljava/lang/String;)Z", "fileName", "fileNamesToIgnore", "(Ljava/lang/String;[Ljava/lang/String;)Z", "deleteDirectory", "dir", "extractFromZip", "zipFile", "fileToExtract", "getChildRelativeToDir", "dirInHeirarchy", "getParentRelativeToDir", "getPid", "pidFileName", "isZipFile", "isZipStream", "Ljava/io/InputStream;", "mkdir", "location", "moveDirectory", "moveFile", "parseDir", "rootDirectory", "extensionsToMatch", "(Ljava/io/File;[Ljava/lang/String;)Ljava/util/List;", "prepend", "strings", "read", "action", "Ldorkbox/util/FileUtil$Action;", "includeEmptyLines", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "lineSeparator", "readAsString", "readFirstLine", "readLines", "Ljava/io/Reader;", "readOnePerLine", "Ljava/util/ArrayList;", "trimStrings", "list", "", "renameTo", "source", "tempDirectory", "directoryName", "tempFile", "toBytes", "touch", "timestamp", "", "unjarzip0", "outputDir", "extractManifest", "unjarzip1", "inputStream", "Ljava/util/zip/ZipInputStream;", "unzip", "unzipJar", "write", "Action", "Utilities"})
public final class FileUtil {
    public static final FileUtil INSTANCE = new FileUtil();
    private static final String version = Sys.INSTANCE.getVersion();
    private static final Logger log;
    private static final boolean DEBUG = false;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR;
    private static final char OTHER_SEPARATOR;
    private static byte[] ZIP_HEADER;

    private FileUtil() {
    }

    public final String getVersion() {
        return version;
    }

    public final byte[] getZIP_HEADER() {
        return ZIP_HEADER;
    }

    public final void setZIP_HEADER(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        ZIP_HEADER = byArray;
    }

    public final void prepend(File file, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : stringArray) {
            linkedList.add(string);
        }
        this.readOnePerLine(file, (List<String>)linkedList, false);
        this.write(file, (List<String>)linkedList);
    }

    public final void append(File object, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file = ((File)object).getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        try {
            object = new FileWriter((File)object, true);
            Throwable throwable = null;
            try {
                Closeable closeable = (FileWriter)object;
                closeable = new BufferedWriter((Writer)closeable);
                Throwable throwable2 = null;
                try {
                    Closeable closeable2 = (BufferedWriter)closeable;
                    closeable2 = new PrintWriter((Writer)closeable2);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable2;
                        for (String string : stringArray) {
                            printWriter.println(string);
                        }
                    }
                    catch (Throwable throwable4) {
                        try {
                            Throwable throwable5 = throwable4;
                            throwable3 = throwable4;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                            throw throwable6;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable2, null);
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        throwable2 = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        throw throwable9;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, null);
            }
            catch (Throwable throwable10) {
                try {
                    Throwable throwable11 = throwable10;
                    throwable = throwable10;
                    throw throwable11;
                }
                catch (Throwable throwable12) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    throw throwable12;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            return;
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
            return;
        }
    }

    public final void write(File object, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file = ((File)object).getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        try {
            object = new FileWriter((File)object, false);
            Throwable throwable = null;
            try {
                Closeable closeable = (FileWriter)object;
                closeable = new BufferedWriter((Writer)closeable);
                Throwable throwable2 = null;
                try {
                    Closeable closeable2 = (BufferedWriter)closeable;
                    closeable2 = new PrintWriter((Writer)closeable2);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable2;
                        for (String string : stringArray) {
                            printWriter.println(string);
                        }
                    }
                    catch (Throwable throwable4) {
                        try {
                            Throwable throwable5 = throwable4;
                            throwable3 = throwable4;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                            throw throwable6;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable2, null);
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        throwable2 = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        throw throwable9;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, null);
            }
            catch (Throwable throwable10) {
                try {
                    Throwable throwable11 = throwable10;
                    throwable = throwable10;
                    throw throwable11;
                }
                catch (Throwable throwable12) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    throw throwable12;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            return;
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
            return;
        }
    }

    public final void write(File object, List<String> object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(object2, (String)"");
        File file = ((File)object).getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        try {
            object = new FileWriter((File)object, false);
            Throwable throwable = null;
            try {
                Closeable closeable = (FileWriter)object;
                closeable = new BufferedWriter((Writer)closeable);
                Throwable throwable2 = null;
                try {
                    Closeable closeable2 = (BufferedWriter)closeable;
                    closeable2 = new PrintWriter((Writer)closeable2);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable2;
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            String string = (String)object2.next();
                            printWriter.println(string);
                        }
                    }
                    catch (Throwable throwable4) {
                        try {
                            Throwable throwable5 = throwable4;
                            throwable3 = throwable4;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                            throw throwable6;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable2, null);
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        throwable2 = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        throw throwable9;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, null);
            }
            catch (Throwable throwable10) {
                try {
                    Throwable throwable11 = throwable10;
                    throwable = throwable10;
                    throw throwable11;
                }
                catch (Throwable throwable12) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    throw throwable12;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            return;
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
            return;
        }
    }

    public final void append(File object, List<String> object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(object2, (String)"");
        File file = ((File)object).getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        try {
            object = new FileWriter((File)object, true);
            Throwable throwable = null;
            try {
                Closeable closeable = (FileWriter)object;
                closeable = new BufferedWriter((Writer)closeable);
                Throwable throwable2 = null;
                try {
                    Closeable closeable2 = (BufferedWriter)closeable;
                    closeable2 = new PrintWriter((Writer)closeable2);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable2;
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            String string = (String)object2.next();
                            printWriter.println(string);
                        }
                    }
                    catch (Throwable throwable4) {
                        try {
                            Throwable throwable5 = throwable4;
                            throwable3 = throwable4;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                            throw throwable6;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable2, null);
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        throwable2 = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        throw throwable9;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, null);
            }
            catch (Throwable throwable10) {
                try {
                    Throwable throwable11 = throwable10;
                    throwable = throwable10;
                    throw throwable11;
                }
                catch (Throwable throwable12) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    throw throwable12;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            return;
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
            return;
        }
    }

    public final List<String> read(File object, boolean bl) {
        List list;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                list = new ArrayList();
                if (!bl) break block8;
                Object object2 = Charsets.UTF_8;
                object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
                object2 = null;
                try {
                    InputStreamReader inputStreamReader = (InputStreamReader)object;
                    TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>((List<String>)list){
                        final /* synthetic */ List<String> $lines;
                        {
                            this.$lines = list;
                            super(1);
                        }

                        public final void invoke(String string) {
                            Intrinsics.checkNotNullParameter((Object)string, (String)"");
                            this.$lines.add(string);
                        }
                    }));
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        object2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)object, null);
                break block9;
            }
            Object object3 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object3);
            object3 = null;
            try {
                InputStreamReader inputStreamReader = (InputStreamReader)object;
                TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>((List<String>)list){
                    final /* synthetic */ List<String> $lines;
                    {
                        this.$lines = list;
                        super(1);
                    }

                    public final void invoke(String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        if (((CharSequence)string).length() > 0) {
                            this.$lines.add(string);
                        }
                    }
                }));
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable4 = throwable;
                    object3 = throwable;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
        }
        return list;
    }

    public final String readAsString(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return FilesKt.readText$default((File)file, null, (int)1, null);
    }

    public final String read(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.read(new File(string));
    }

    public final String read(File object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = FilesKt.readText$default((File)object, null, (int)1, null);
        if (((CharSequence)object).length() == 0) {
            return null;
        }
        return object;
    }

    public final void read(File object, StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        object = new FileReader((File)object);
        Throwable throwable = null;
        try {
            Reader reader = (FileReader)object;
            reader = new BufferedReader(reader);
            while (true) {
                String string;
                String string2 = string = ((BufferedReader)reader).readLine();
                string2 = string;
                if (string == null) break;
                stringBuilder.append(string2).append(OS.INSTANCE.getLINE_SEPARATOR());
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally((Closeable)object, null);
        return;
    }

    public final boolean read(File object, StringBuilder stringBuilder, String string) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        if (!((File)object).canRead()) {
            return false;
        }
        try {
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader inputStreamReader = (InputStreamReader)object;
                TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>(string, stringBuilder){
                    final /* synthetic */ String $lineSeparator;
                    final /* synthetic */ StringBuilder $builder;
                    {
                        this.$lineSeparator = string;
                        this.$builder = stringBuilder;
                        super(1);
                    }

                    public final void invoke(String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        if (this.$lineSeparator != null) {
                            this.$builder.append(string).append(this.$lineSeparator);
                            return;
                        }
                        this.$builder.append(string);
                    }
                }));
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object2 = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public final boolean read(File object, Action action) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)action, (String)"");
        if (!((File)object).canRead()) {
            return false;
        }
        try {
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader inputStreamReader = (InputStreamReader)object;
                TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>(action){
                    final /* synthetic */ Action $action;
                    {
                        this.$action = action;
                        super(1);
                    }

                    public final void invoke(String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        this.$action.onLineRead(string);
                    }
                }));
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object2 = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
        }
        catch (Exception exception) {
            return false;
        }
        action.finished();
        return true;
    }

    public final String readFirstLine(File object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!((File)object).canRead()) {
            return "";
        }
        Object object3 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object3);
        object3 = null;
        try {
            object2 = (InputStreamReader)object;
            object2 = (Reader)object2;
            object2 = (String)SequencesKt.firstOrNull((Sequence)TextStreamsKt.lineSequence((BufferedReader)new BufferedReader((Reader)object2, 8192)));
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object3 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)object, null);
        Object object4 = object2;
        Object object5 = object4;
        if (object4 == null) {
            object5 = "";
        }
        return object5;
    }

    public final String getPid(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.read(new File(string), stringBuilder, null)) {
            return stringBuilder.toString();
        }
        return null;
    }

    public final List<String> readLines(File object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        try {
            object = new FileReader((File)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new ArrayList();
        }
        return this.readLines((Reader)object);
    }

    public final List<String> readLines(Reader object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        List list = new ArrayList();
        Closeable closeable = new BufferedReader((Reader)object);
        Throwable throwable = null;
        try {
            BufferedReader cfr_ignored_0 = (BufferedReader)closeable;
            object = new BufferedReader((Reader)object);
            try {
                while (true) {
                    String string;
                    String string2 = string = ((BufferedReader)object).readLine();
                    Intrinsics.checkNotNull((Object)string);
                    if (string != null) {
                        list.add(string2);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        return list;
    }

    public final ArrayList<String> readOnePerLine(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readOnePerLine(file, (List<String>)arrayList, true);
        return arrayList;
    }

    public final ArrayList<String> readOnePerLine(File file, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readOnePerLine(file, (List<String>)arrayList, bl);
        return arrayList;
    }

    public final void readOnePerLine(File file, List<String> list, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (bl) {
            this.read(file, new Action(list){
                private int lineNumber;
                final /* synthetic */ List<String> $list;
                {
                    this.$list = list;
                }

                public final int getLineNumber() {
                    return this.lineNumber;
                }

                public final void setLineNumber(int n) {
                    this.lineNumber = n;
                }

                public final void onLineRead(String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"");
                    if (((CharSequence)string).length() > 0 && !StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null) && ((CharSequence)(string = ((Object)StringsKt.trim((CharSequence)string)).toString())).length() > 0) {
                        this.$list.add(string);
                    }
                    int n = this.lineNumber;
                    this.lineNumber = n + 1;
                }

                public final void finished() {
                }
            });
            return;
        }
        this.read(file, new Action(list){
            private int lineNumber;
            final /* synthetic */ List<String> $list;
            {
                this.$list = list;
            }

            public final int getLineNumber() {
                return this.lineNumber;
            }

            public final void setLineNumber(int n) {
                this.lineNumber = n;
            }

            public final void onLineRead(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                this.$list.add(string);
                int n = this.lineNumber;
                this.lineNumber = n + 1;
            }

            public final void finished() {
            }
        });
    }

    public final boolean deleteDirectory(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        try {
            return FilesKt.deleteRecursively((File)file);
        }
        catch (IOException iOException) {
            log.error("Error deleting the contents of dir " + file, (Throwable)iOException);
        }
        catch (DirectoryIteratorException directoryIteratorException) {
            log.error("Error deleting the contents of dir " + file, (Throwable)directoryIteratorException);
        }
        return false;
    }

    public final boolean renameTo(File file, File file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        if (file.renameTo(file2)) {
            return true;
        }
        if (file2.exists()) {
            File file3 = new File(file2.getPath() + "_old");
            if (file3.exists()) {
                file3.delete();
            }
            if (file2.renameTo(file3) && file.renameTo(file2)) {
                file3.delete();
                return true;
            }
        }
        try {
            FilesKt.copyTo$default((File)file, (File)file2, (boolean)false, (int)0, (int)6, null);
            file.delete();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public final File copyFile(String string, File file) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return this.copyFile(new File(string), file);
    }

    public final File copyFile(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.copyFile(file, new File(string));
    }

    public final File copyFile(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return this.copyFile(new File(string), new File(string2));
    }

    public final File copyFileToDir(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return this.copyFileToDir(new File(string), new File(string2));
    }

    public final File copyFileToDir(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        if (!file2.isDirectory()) {
            throw new IOException("Out file is not a directory! '" + file2.getAbsolutePath() + '\'');
        }
        return this.copyFile(file, new File(file2, file.getName()));
    }

    public final File copyFile(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        Object object = FilesKt.normalize((File)file).getAbsolutePath();
        String string = FilesKt.normalize((File)file2).getAbsolutePath();
        if (StringsKt.equals((String)object, (String)string, (boolean)true)) {
            return file2;
        }
        object = file2.getParentFile();
        boolean bl = object != null ? !((File)object).canWrite() : false;
        if (bl) {
            ((File)object).mkdirs();
        }
        FilesKt.copyTo$default((File)file, (File)file2, (boolean)false, (int)0, (int)6, null);
        file2.setLastModified(file.lastModified());
        return file2;
    }

    public final File concatFiles(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        FilesKt.appendBytes((File)file, (byte[])FilesKt.readBytes((File)file2));
        file.setLastModified(System.currentTimeMillis());
        return file;
    }

    public final File moveFile(String string, File file) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return this.moveFile(new File(string), file);
    }

    public final File moveFile(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.moveFile(file, new File(string));
    }

    public final File moveFile(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return this.moveFile(new File(string), new File(string2));
    }

    public final File moveFile(File file, File file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        if (file2.canRead()) {
            file2.delete();
        }
        if (!(bl = this.renameTo(file, file2))) {
            throw new IOException("Unable to move file: '" + file.getAbsolutePath() + "' -> '" + file2.getAbsolutePath() + '\'');
        }
        return file2;
    }

    public final void copyDirectory(String string, String string2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.copyDirectory(new File(string), new File(string2), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final void copyDirectory(File file, File file2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        file = FilesKt.normalize((File)file);
        file2 = FilesKt.normalize((File)file2);
        if (file == null) {
            String string = "Source must be valid";
            throw new IllegalArgumentException(string.toString());
        }
        if (file2 == null) {
            String string = "Destination must be valid";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(stringArray.length == 0)) {
            String object2 = file.getName();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (!Intrinsics.areEqual((Object)object2, (Object)string)) continue;
                return;
            }
        }
        if (file.isDirectory()) {
            String[] stringArray2;
            if (!file2.exists()) {
                file2.mkdir();
            }
            if ((stringArray2 = file.list()) != null) {
                for (String string : stringArray2) {
                    File file3 = new File(file, string);
                    File file4 = new File(file2, string);
                    this.copyDirectory(file3, file4, Arrays.copyOf(stringArray, stringArray.length));
                }
            }
        } else {
            this.copyFile(file, file2);
        }
    }

    public final void moveDirectory(String string, String string2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.moveDirectory(new File(string), new File(string2), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final void moveDirectory(File file, File file2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        if (stringArray.length > 0) {
            String object2 = file.getName();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (!Intrinsics.areEqual((Object)object2, (Object)string)) continue;
                return;
            }
        }
        if (file.isDirectory()) {
            String[] stringArray2;
            if (!file2.exists()) {
                file2.mkdir();
            }
            if ((stringArray2 = file.list()) != null) {
                for (String string : stringArray2) {
                    File file3 = new File(file, string);
                    File file4 = new File(file2, string);
                    this.moveDirectory(file3, file4, Arrays.copyOf(stringArray, stringArray.length));
                }
            }
        } else {
            this.moveFile(file, file2);
        }
    }

    public final boolean delete(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.delete(new File(string), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final boolean delete(File file, String ... stringArray) {
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        if (!file.exists()) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl3 = true;
                File file2 = fileArray[i];
                String string = file2.getName();
                Intrinsics.checkNotNull((Object)file2);
                String string2 = FilesKt.normalize((File)file2).getAbsolutePath();
                if (file2.isDirectory()) {
                    int n2 = stringArray.length;
                    for (int j = 0; j < n2; ++j) {
                        String string3 = stringArray[j];
                        if (string3.charAt(0) == '/' && Intrinsics.areEqual((Object)string3, (Object)string)) {
                            bl2 = true;
                            bl3 = false;
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)string3, (Object)string2)) continue;
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    if (!bl3) continue;
                    this.delete(file2, Arrays.copyOf(stringArray, stringArray.length));
                    continue;
                }
                for (String string3 : stringArray) {
                    if (string3.charAt(0) != '/' && Intrinsics.areEqual((Object)string3, (Object)string)) {
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)string3, (Object)string2)) continue;
                    bl2 = true;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                bl |= file2.delete();
            }
        }
        if (bl2) {
            return false;
        }
        return bl |= file.delete();
    }

    public final byte[] toBytes(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return FilesKt.readBytes((File)file);
    }

    public final String mkdir(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        File file2 = FilesKt.normalize((File)file).getAbsoluteFile();
        file.mkdirs();
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String mkdir(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.mkdir(new File(string));
    }

    public final File tempFile(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        File file = File.createTempFile(string, null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"");
        File file2 = FilesKt.normalize((File)file).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"");
        return file2;
    }

    public final String tempDirectory(String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = File.createTempFile((String)object, null);
        if (!((File)object).delete()) {
            throw new IOException("Unable to delete temp file: " + object);
        }
        if (!((File)object).mkdir()) {
            throw new IOException("Unable to create temp directory: " + object);
        }
        Intrinsics.checkNotNull((Object)object);
        String string = FilesKt.normalize((File)object).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final boolean isZipStream(InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl = true;
        try {
            inputStream.mark(ZIP_HEADER.length);
            int n = ZIP_HEADER.length;
            for (int i = 0; i < n; ++i) {
                if (ZIP_HEADER[i] == (byte)inputStream.read()) continue;
                bl = false;
                break;
            }
            inputStream.reset();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public final boolean isZipFile(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.isZipFile(new File(string));
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isZipFile(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        boolean bl = true;
        byte[] byArray = new byte[ZIP_HEADER.length];
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.readFully(byArray);
        int n = ZIP_HEADER.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == ZIP_HEADER[i]) continue;
            bl = false;
            break;
        }
        try {
            randomAccessFile.close();
            return bl;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return bl;
        catch (Exception exception) {
            try {
                bl = false;
                FileNotFoundException fileNotFoundException = exception instanceof FileNotFoundException ? (FileNotFoundException)exception : null;
                if (fileNotFoundException != null) {
                    fileNotFoundException.printStackTrace();
                }
                if (randomAccessFile == null) return bl;
            }
            catch (Throwable throwable) {
                if (randomAccessFile == null) throw throwable;
                try {
                    randomAccessFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException3 = iOException;
                    iOException.printStackTrace();
                }
                throw throwable;
            }
            try {
                randomAccessFile.close();
                return bl;
            }
            catch (IOException iOException) {
                IOException iOException4 = iOException;
                iOException.printStackTrace();
            }
            return bl;
        }
    }

    public final void unzip(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.unzipJar(string, string2, true);
    }

    public final void unzip(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        this.unzipJar(file, file2, true);
    }

    public final void unzip(ZipInputStream zipInputStream, String string) {
        Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.unzip(zipInputStream, new File(string));
    }

    public final void unzip(ZipInputStream zipInputStream, File file) {
        Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.unzipJar(zipInputStream, file, true);
    }

    public final void unzipJar(String string, String string2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.unjarzip0(new File(string), new File(string2), bl);
    }

    public final void unzipJar(File file, File file2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        this.unjarzip0(file, file2, bl);
    }

    public final void unzipJar(ZipInputStream zipInputStream, File file, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.unjarzip1(zipInputStream, file, bl);
    }

    private final void unjarzip0(File object, File file, boolean bl) {
        long l = ((File)object).length();
        if (l > 0x7FFFFFFEL) {
            throw new RuntimeException("Source filesize is too large!");
        }
        object = new ZipInputStream(new FileInputStream((File)object));
        this.unjarzip1((ZipInputStream)object, file, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unjarzip1(ZipInputStream object, File file, boolean bl) {
        Closeable closeable = (Closeable)object;
        Throwable throwable = null;
        try {
            ZipInputStream cfr_ignored_0 = (ZipInputStream)closeable;
            while (true) {
                Object object4;
                Object object3 = object4 = ((ZipInputStream)object).getNextEntry();
                Object object2 = object4;
                if (object4 == null) break;
                ZipEntry zipEntry = object2;
                Intrinsics.checkNotNull((Object)zipEntry);
                object4 = zipEntry.getName();
                if (!bl) {
                    Intrinsics.checkNotNull((Object)object4);
                    if (StringsKt.startsWith$default((String)object4, (String)"META-INF/", (boolean)false, (int)2, null)) continue;
                }
                object3 = new File(file, (String)object4);
                if (((ZipEntry)object2).isDirectory()) {
                    String string = ((File)object3).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    INSTANCE.mkdir(string);
                    continue;
                }
                String string = ((File)object3).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                INSTANCE.mkdir(string);
                object2 = new FileOutputStream((File)object3);
                object4 = null;
                try {
                    object3 = (FileOutputStream)object2;
                    ByteStreamsKt.copyTo$default((InputStream)((InputStream)object), (OutputStream)((OutputStream)object3), (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    try {
                        object3 = throwable2;
                        object4 = throwable2;
                        throw object3;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)object2, null);
            }
        }
        catch (Throwable throwable3) {
            try {
                object = throwable3;
                throwable = throwable3;
                throw object;
            }
            catch (Throwable throwable5) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable5;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
    }

    public final List<File> parseDir(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.parseDir(new File(string));
    }

    public final List<File> parseDir(File file) {
        while (true) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"");
        }
    }

    public final List<File> parseDir(File fileArray, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)fileArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        List list = new LinkedList();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        fileArray = FilesKt.normalize((File)fileArray);
        if (!fileArray.exists()) {
            throw new IOException("Location does not exist: " + fileArray.getAbsolutePath());
        }
        if (fileArray.isDirectory()) {
            linkedList.add(fileArray);
            while (linkedList.peek() != null) {
                fileArray = (File)linkedList.poll();
                Intrinsics.checkNotNull((Object)fileArray);
                if ((fileArray = fileArray.listFiles()) == null) continue;
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        linkedList.add(file);
                        continue;
                    }
                    if (stringArray.length == 0) {
                        Intrinsics.checkNotNull((Object)file);
                        list.add(file);
                        continue;
                    }
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string = stringArray[i];
                        String string2 = file.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                        if (!StringsKt.endsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) continue;
                        Intrinsics.checkNotNull((Object)file);
                        list.add(file);
                    }
                }
            }
        } else {
            throw new IOException("Cannot search directory children if the dir is a file name: " + fileArray.getAbsolutePath());
        }
        return list;
    }

    public final String getChildRelativeToDir(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            string = "fileName cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.getChildRelativeToDir(new File(string), string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getChildRelativeToDir(File object, String string) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            String string2 = "dirInHeirarchy cannot be empty.";
            throw new IllegalArgumentException(string2.toString());
        }
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        String string3 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        stringArray[0] = string3;
        Collection collection = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        Object object2 = collection;
        String[] stringArray3 = collection.toArray(new String[0]);
        int n = stringArray3.length - 1;
        String string4 = ((File)object).getAbsolutePath();
        if (n == 0) {
            for (object2 = object; object2 != null; object2 = ((File)object2).getParentFile()) {
                Intrinsics.checkNotNullExpressionValue((Object)((File)object2).getName(), (String)"");
                if (!Intrinsics.areEqual((Object)object, (Object)string)) continue;
                String string5 = ((File)object2).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                object = string5;
                Intrinsics.checkNotNull((Object)string4);
                String string6 = string4.substring(((String)object).length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                return string6;
            }
            return null;
        } else {
            boolean bl = false;
            while (object2 != null) {
                void var4_7;
                Intrinsics.checkNotNullExpressionValue((Object)((File)object2).getName(), (String)"");
                if (bl) {
                    if (!Intrinsics.areEqual((Object)object, (Object)stringArray3[var4_7])) return null;
                    if (--var4_7 < 0) {
                        if (string4.length() == string.length()) {
                            return null;
                        }
                        Intrinsics.checkNotNull((Object)string4);
                        String string7 = string4.substring(string.length() + 1, string4.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
                        return string7;
                    }
                } else if (Intrinsics.areEqual((Object)object, (Object)stringArray3[var4_7])) {
                    bl = true;
                    --var4_7;
                }
                object2 = ((File)object2).getParentFile();
            }
        }
        return null;
    }

    public final String getParentRelativeToDir(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            string = "fileName cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.getParentRelativeToDir(new File(string), string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getParentRelativeToDir(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            String string2 = "dirInHeirarchy cannot be empty.";
            throw new IllegalArgumentException(string2.toString());
        }
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        String string3 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        stringArray[0] = string3;
        Collection collection = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        Object object = collection;
        String[] stringArray3 = collection.toArray(new String[0]);
        int n = stringArray3.length - 1;
        if (n == 0) {
            while (file != null) {
                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"");
                if (Intrinsics.areEqual((Object)object, (Object)string)) {
                    file = file.getParentFile();
                    String string4 = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                    object = string4;
                    return string4;
                }
                file = file.getParentFile();
            }
            return null;
        } else {
            boolean bl = false;
            while (file != null) {
                void var4_8;
                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"");
                if (bl) {
                    if (!Intrinsics.areEqual((Object)object, (Object)stringArray3[var4_8])) return null;
                    if (--var4_8 < 0) {
                        file = file.getParentFile();
                        String string5 = file.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                        object = string5;
                        return string5;
                    }
                } else if (Intrinsics.areEqual((Object)object, (Object)stringArray3[var4_8])) {
                    bl = true;
                    --var4_8;
                }
                file = file.getParentFile();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String extractFromZip(String object, String object2) {
        block11: {
            block10: {
                Object object3;
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                Intrinsics.checkNotNullParameter((Object)object2, (String)"");
                object = new ZipInputStream(new FileInputStream((String)object));
                Throwable throwable = null;
                try {
                    Object object4;
                    object3 = (ZipInputStream)object;
                    while ((object4 = ((ZipInputStream)object3).getNextEntry()) != null) {
                        Intrinsics.checkNotNull((Object)object4);
                        Object object5 = object4;
                        object4 = ((ZipEntry)object5).getName();
                        if (((ZipEntry)object5).isDirectory() || !Intrinsics.areEqual((Object)object4, (Object)object2)) continue;
                        Intrinsics.checkNotNull((Object)object4);
                        object2 = INSTANCE.tempFile((String)object4);
                        ((File)object2).deleteOnExit();
                        object4 = new FileOutputStream((File)object2);
                        object4 = (Closeable)object4;
                        object5 = null;
                        try {
                            FileOutputStream fileOutputStream = (FileOutputStream)object4;
                            ByteStreamsKt.copyTo$default((InputStream)((InputStream)object3), (OutputStream)fileOutputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                object5 = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                                throw throwable4;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)object4, null);
                        object2 = ((File)object2).getAbsolutePath();
                        break block10;
                    }
                    break block11;
                }
                catch (Throwable throwable5) {
                    try {
                        object3 = throwable5;
                        throwable = throwable5;
                        throw object3;
                    }
                    catch (Throwable throwable6) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        throw throwable6;
                    }
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            return object2;
        }
        CloseableKt.closeFinally((Closeable)object, null);
        return null;
    }

    public final boolean touch(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        long l = System.currentTimeMillis();
        File file = new File(string).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"");
        return this.touch(file, l);
    }

    public final boolean touch(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        long l = System.currentTimeMillis();
        return this.touch(file, l);
    }

    public final boolean touch(File file, long l) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        if (!file.exists()) {
            boolean bl = file.getParentFile().mkdirs();
            if (!bl) {
                return false;
            }
            try {
                new FileOutputStream(file).close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return file.setLastModified(l);
    }

    static {
        Logger logger = LoggerFactory.getLogger(FileUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        log = logger;
        SYSTEM_SEPARATOR = File.separatorChar;
        OTHER_SEPARATOR = (char)(OS.INSTANCE.isWindows() ? 47 : 92);
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = 80;
        byArray2[1] = 75;
        byArray2[2] = 3;
        byArray2[3] = 4;
        ZIP_HEADER = byArray2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Ldorkbox/util/FileUtil$Action;", "", "finished", "", "onLineRead", "line", "", "Utilities"})
    public static interface Action {
        public void onLineRead(String var1);

        public void finished();
    }
}

