/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.userManagement;

import dorkbox.util.userManagement.UserManagement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public final class Group
implements Serializable {
    private final UUID uuid;
    private String name;
    private Set<UUID> users = new HashSet<UUID>();

    public Group(String string) {
        this(string, UserManagement.UUID_GENERATOR.a());
    }

    Group(String string, UUID uUID) {
        this.name = string;
        this.uuid = uUID;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized void addUser(UUID uUID) {
        this.users.add(uUID);
    }

    public final synchronized void removeUser(UUID uUID) {
        this.users.remove(uUID);
    }

    public final synchronized Collection<UUID> getUsers() {
        return Collections.unmodifiableCollection(this.users);
    }

    public final synchronized boolean isEmpty() {
        return this.users.isEmpty();
    }

    public final synchronized void remove() {
        this.users.clear();
    }

    public final String toString() {
        return "Group '" + this.name + '\'';
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (Group)object;
        if (this.uuid != null) {
            return this.uuid.equals(((Group)object).uuid);
        }
        return ((Group)object).uuid == null;
    }

    public final int hashCode() {
        if (this.uuid != null) {
            return this.uuid.hashCode();
        }
        return 0;
    }
}

