/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.SimpleFunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;

public final class FunctionInvokeDescriptor
extends SimpleFunctionDescriptorImpl {
    public static final Factory Factory = new Factory(null);

    private FunctionInvokeDescriptor(DeclarationDescriptor declarationDescriptor, FunctionInvokeDescriptor functionInvokeDescriptor, CallableMemberDescriptor.Kind kind, boolean bl) {
        super(declarationDescriptor, functionInvokeDescriptor, Annotations.Companion.getEMPTY(), OperatorNameConventions.INVOKE, kind, SourceElement.NO_SOURCE);
        this.setOperator(true);
        this.setSuspend(bl);
        this.setHasStableParameterNames(false);
    }

    @Override
    protected final FunctionDescriptor doSubstitute(FunctionDescriptorImpl.CopyConfiguration object) {
        boolean bl;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        FunctionInvokeDescriptor functionInvokeDescriptor = (FunctionInvokeDescriptor)super.doSubstitute((FunctionDescriptorImpl.CopyConfiguration)object);
        if (functionInvokeDescriptor == null) {
            return null;
        }
        object = functionInvokeDescriptor;
        List<ValueParameterDescriptor> list = functionInvokeDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Object object4 = list;
        if (!(object4 instanceof Collection) || !((Collection)object4).isEmpty()) {
            object4 = object4.iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                object2 = (ValueParameterDescriptor)object3;
                KotlinType kotlinType = object2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                if (!(FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType) != null)) continue;
                bl = false;
                break;
            }
        } else {
            bl = true;
        }
        if (bl) {
            return (FunctionDescriptor)object;
        }
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptorImpl)object).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"");
        object3 = object4 = (Iterable)list2;
        object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
        object4 = object3.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            object3 = (ValueParameterDescriptor)object3;
            Object object5 = object2;
            KotlinType kotlinType = object3.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            object5.add(FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType));
        }
        object4 = (List)object2;
        return super.replaceParameterNames((List<Name>)object4);
    }

    @Override
    protected final FunctionDescriptorImpl createSubstitutedCopy(DeclarationDescriptor declarationDescriptor, FunctionDescriptor functionDescriptor, CallableMemberDescriptor.Kind kind, Name name, Annotations annotations, SourceElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        return new FunctionInvokeDescriptor(declarationDescriptor, (FunctionInvokeDescriptor)functionDescriptor, kind, this.isSuspend());
    }

    @Override
    public final boolean isExternal() {
        return false;
    }

    @Override
    public final boolean isInline() {
        return false;
    }

    @Override
    public final boolean isTailrec() {
        return false;
    }

    private final FunctionDescriptor replaceParameterNames(List<Name> object) {
        boolean bl;
        Object object2;
        Object object3;
        Object object4;
        Collection collection;
        Object object5;
        boolean bl2;
        int n = this.getValueParameters().size() - object.size();
        boolean bl3 = bl2 = n == 0 || n == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (n == 0) {
            boolean bl4;
            Iterable iterable = (Iterable)object;
            List<ValueParameterDescriptor> list = this.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Object object6 = CollectionsKt.zip((Iterable)iterable, (Iterable)list);
            if (!(object6 instanceof Collection) || !((Collection)object6).isEmpty()) {
                object6 = object6.iterator();
                while (object6.hasNext()) {
                    object5 = object6.next();
                    collection = (Pair)object5;
                    if (Intrinsics.areEqual((Object)(object5 = (Name)collection.component1()), (Object)(object4 = (ValueParameterDescriptor)collection.component2()).getName())) continue;
                    bl4 = false;
                    break;
                }
            } else {
                bl4 = true;
            }
            if (bl4) {
                return this;
            }
        }
        List<ValueParameterDescriptor> list = this.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        object5 = object3 = (Iterable)list;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        object5 = object5.iterator();
        while (object5.hasNext()) {
            Name name;
            object4 = object5.next();
            object3 = (ValueParameterDescriptor)object4;
            object2 = collection;
            Name name2 = object3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
            object4 = name2;
            int n2 = object3.getIndex();
            int n3 = n2 - n;
            if (n3 >= 0 && (name = (Name)object.get(n3)) != null) {
                object4 = name;
            }
            object2.add(object3.copy(this, (Name)object4, n2));
        }
        object3 = (List)collection;
        object5 = (Iterable)object;
        object2 = this.newCopyBuilder(TypeSubstitutor.EMPTY);
        if (!(object5 instanceof Collection) || !((Collection)object5).isEmpty()) {
            object = object5.iterator();
            while (object.hasNext()) {
                object5 = object.next();
                object4 = (Name)object5;
                if (!(object4 == null)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        boolean bl5 = bl;
        FunctionDescriptorImpl.CopyConfiguration copyConfiguration = ((FunctionDescriptorImpl.CopyConfiguration)((FunctionDescriptorImpl.CopyConfiguration)object2).setHasSynthesizedParameterNames(bl5).setValueParameters((List)object3)).setOriginal(this.getOriginal());
        Intrinsics.checkNotNullExpressionValue((Object)copyConfiguration, (String)"");
        object3 = copyConfiguration;
        FunctionDescriptor functionDescriptor = super.doSubstitute((FunctionDescriptorImpl.CopyConfiguration)object3);
        Intrinsics.checkNotNull((Object)functionDescriptor);
        return functionDescriptor;
    }

    public /* synthetic */ FunctionInvokeDescriptor(DeclarationDescriptor declarationDescriptor, FunctionInvokeDescriptor functionInvokeDescriptor, CallableMemberDescriptor.Kind kind, boolean bl, DefaultConstructorMarker defaultConstructorMarker) {
        this(declarationDescriptor, functionInvokeDescriptor, kind, bl);
    }

    public static final class Factory {
        private Factory() {
        }

        public final FunctionInvokeDescriptor create(FunctionClassDescriptor object, boolean bl) {
            Object object2;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            List<TypeParameterDescriptor> list = ((FunctionClassDescriptor)object).getDeclaredTypeParameters();
            FunctionInvokeDescriptor functionInvokeDescriptor = new FunctionInvokeDescriptor((DeclarationDescriptor)object, null, CallableMemberDescriptor.Kind.DECLARATION, bl, null);
            ReceiverParameterDescriptor receiverParameterDescriptor = ((AbstractClassDescriptor)object).getThisAsReceiverParameter();
            object = list;
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            FunctionInvokeDescriptor functionInvokeDescriptor2 = functionInvokeDescriptor;
            Object object4 = new ArrayList<List>();
            object = object.iterator();
            while (object.hasNext() && (object3 = (TypeParameterDescriptor)(object2 = object.next())).getVariance() == Variance.IN_VARIANCE) {
                ((ArrayList)object4).add(object2);
            }
            object2 = (List)object4;
            object4 = object = CollectionsKt.withIndex((Iterable)((Iterable)object2));
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object4 = object3.next();
                object4 = (IndexedValue)object4;
                object2 = object;
                object2.add(Factory.createValueParameter(functionInvokeDescriptor, object4.getIndex(), (TypeParameterDescriptor)object4.getValue()));
            }
            object2 = (List)object;
            functionInvokeDescriptor2.initialize((ReceiverParameterDescriptor)null, receiverParameterDescriptor2, list3, list2, (List)object2, (KotlinType)((TypeParameterDescriptor)CollectionsKt.last(list)).getDefaultType(), Modality.ABSTRACT, DescriptorVisibilities.PUBLIC);
            functionInvokeDescriptor.setHasSynthesizedParameterNames(true);
            return functionInvokeDescriptor;
        }

        private final ValueParameterDescriptor createValueParameter(FunctionInvokeDescriptor functionInvokeDescriptor, int n, TypeParameterDescriptor typeParameterDescriptor) {
            String string;
            String string2 = typeParameterDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string2;
            if (Intrinsics.areEqual((Object)string2, (Object)"T")) {
                string = "instance";
            } else if (Intrinsics.areEqual((Object)string3, (Object)"E")) {
                string = "receiver";
            } else {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            }
            string3 = string;
            CallableDescriptor callableDescriptor = functionInvokeDescriptor;
            Annotations annotations = Annotations.Companion.getEMPTY();
            Name name = Name.identifier(string3);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            SimpleType simpleType = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            KotlinType kotlinType = simpleType;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
            return new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations, name, kotlinType, false, false, false, null, sourceElement);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

